/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

public final class FastStack {
    private Object[] stack;
    private int pointer;

    public FastStack(int n2) {
        this.stack = new Object[n2];
    }

    public Object push(Object object) {
        if (this.pointer + 1 >= this.stack.length) {
            this.resizeStack(this.stack.length * 2);
        }
        this.stack[this.pointer++] = object;
        return object;
    }

    public void popSilently() {
        this.stack[--this.pointer] = null;
    }

    public Object pop() {
        Object object = this.stack[--this.pointer];
        this.stack[this.pointer] = null;
        return object;
    }

    public Object peek() {
        return this.pointer == 0 ? null : this.stack[this.pointer - 1];
    }

    public Object replace(Object object) {
        Object object2 = this.stack[this.pointer - 1];
        this.stack[this.pointer - 1] = object;
        return object2;
    }

    public void replaceSilently(Object object) {
        this.stack[this.pointer - 1] = object;
    }

    public int size() {
        return this.pointer;
    }

    public boolean hasStuff() {
        return this.pointer > 0;
    }

    public Object get(int n2) {
        return this.stack[n2];
    }

    private void resizeStack(int n2) {
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.stack, 0, objectArray, 0, Math.min(this.pointer, n2));
        this.stack = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i2 = 0; i2 < this.pointer; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.stack[i2]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

