/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;

public class Fields {
    public static Field locate(Class clazz, Class clazz2, boolean bl2) {
        AccessibleObject accessibleObject = null;
        try {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (Modifier.isStatic(fieldArray[i2].getModifiers()) != bl2 || !clazz2.isAssignableFrom(fieldArray[i2].getType())) continue;
                accessibleObject = fieldArray[i2];
            }
            if (accessibleObject != null && !accessibleObject.isAccessible()) {
                ((Field)accessibleObject).setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return accessibleObject;
    }

    public static Field find(Class clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (SecurityException securityException) {
            throw Fields.wrap("Cannot access field", clazz, string, securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw Fields.wrap("Cannot access field", clazz, string, noSuchFieldException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw Fields.wrap("Cannot access field", clazz, string, noClassDefFoundError);
        }
    }

    public static void write(Field field, Object object, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (SecurityException securityException) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), illegalAccessException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), noClassDefFoundError);
        }
    }

    public static Object read(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (SecurityException securityException) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), illegalAccessException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), noClassDefFoundError);
        }
    }

    private static ObjectAccessException wrap(String string, Class clazz, String string2, Throwable throwable) {
        ObjectAccessException objectAccessException = new ObjectAccessException(string, throwable);
        objectAccessException.add("field", clazz.getName() + "." + string2);
        return objectAccessException;
    }
}

