/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

public class ISO8601JavaTimeConverter
extends AbstractSingleValueConverter {
    private static final DateTimeFormatter STD_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter STD_ORDINAL_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyy-DDD'T'HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter BASIC_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyyMMdd'T'HHmmss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter BASIC_ORDINAL_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyyDDD'T'HHmmss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter BASIC_TIME = new DateTimeFormatterBuilder().appendPattern("HHmmss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter ISO_TTIME = new DateTimeFormatterBuilder().appendPattern("'T'HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter BASIC_TTIME = new DateTimeFormatterBuilder().appendPattern("'T'HHmmss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter ISO_WEEK_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("YYYY-'W'ww-e'T'HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter BASIC_WEEK_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("YYYY'W'wwe'T'HHmmss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).appendOffsetId().toFormatter();
    private static final DateTimeFormatter BASIC_ORDINAL_DATE = new DateTimeFormatterBuilder().appendPattern("yyyyDDD").toFormatter();
    private static final DateTimeFormatter BASIC_WEEK_DATE = new DateTimeFormatterBuilder().appendPattern("YYYY'W'wwe").toFormatter();
    private static final DateTimeFormatter STD_DATE_HOUR = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH").toFormatter();
    private static final DateTimeFormatter STD_HOUR = new DateTimeFormatterBuilder().appendPattern("HH").toFormatter();
    private static final DateTimeFormatter STD_YEAR_WEEK = new DateTimeFormatterBuilder().appendPattern("YYYY-'W'ww").parseDefaulting(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR, 1L).toFormatter();

    @Override
    public boolean canConvert(Class clazz) {
        return false;
    }

    @Override
    public Object fromString(String string) {
        try {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(string);
            return GregorianCalendar.from(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()));
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(string);
                return GregorianCalendar.from(localDateTime.atZone(ZoneId.systemDefault()));
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    Instant instant = Instant.parse(string);
                    return GregorianCalendar.from(instant.atZone(ZoneId.systemDefault()));
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    try {
                        OffsetDateTime offsetDateTime = BASIC_DATE_TIME.parse((CharSequence)string, OffsetDateTime::from);
                        return GregorianCalendar.from(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()));
                    }
                    catch (DateTimeParseException dateTimeParseException4) {
                        try {
                            OffsetDateTime offsetDateTime = STD_ORDINAL_DATE_TIME.parse((CharSequence)string, OffsetDateTime::from);
                            return GregorianCalendar.from(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()));
                        }
                        catch (DateTimeParseException dateTimeParseException5) {
                            try {
                                OffsetDateTime offsetDateTime = BASIC_ORDINAL_DATE_TIME.parse((CharSequence)string, OffsetDateTime::from);
                                return GregorianCalendar.from(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()));
                            }
                            catch (DateTimeParseException dateTimeParseException6) {
                                try {
                                    OffsetTime offsetTime = OffsetTime.parse(string);
                                    return GregorianCalendar.from(offsetTime.atDate(LocalDate.ofEpochDay(0L)).atZoneSameInstant(ZoneId.systemDefault()));
                                }
                                catch (DateTimeParseException dateTimeParseException7) {
                                    try {
                                        OffsetTime offsetTime = BASIC_TIME.parse((CharSequence)string, OffsetTime::from);
                                        return GregorianCalendar.from(offsetTime.atDate(LocalDate.ofEpochDay(0L)).atZoneSameInstant(ZoneId.systemDefault()));
                                    }
                                    catch (DateTimeParseException dateTimeParseException8) {
                                        try {
                                            OffsetTime offsetTime = ISO_TTIME.parse((CharSequence)string, OffsetTime::from);
                                            return GregorianCalendar.from(offsetTime.atDate(LocalDate.ofEpochDay(0L)).atZoneSameInstant(ZoneId.systemDefault()));
                                        }
                                        catch (DateTimeParseException dateTimeParseException9) {
                                            try {
                                                OffsetTime offsetTime = BASIC_TTIME.parse((CharSequence)string, OffsetTime::from);
                                                return GregorianCalendar.from(offsetTime.atDate(LocalDate.ofEpochDay(0L)).atZoneSameInstant(ZoneId.systemDefault()));
                                            }
                                            catch (DateTimeParseException dateTimeParseException10) {
                                                try {
                                                    TemporalAccessor temporalAccessor = ISO_WEEK_DATE_TIME.withLocale(Locale.getDefault()).parse(string);
                                                    Year year = Year.from(temporalAccessor);
                                                    MonthDay monthDay = MonthDay.from(temporalAccessor);
                                                    OffsetTime offsetTime = OffsetTime.from(temporalAccessor);
                                                    return GregorianCalendar.from(offsetTime.atDate(year.atMonthDay(monthDay)).atZoneSameInstant(ZoneId.systemDefault()));
                                                }
                                                catch (DateTimeParseException dateTimeParseException11) {
                                                    try {
                                                        TemporalAccessor temporalAccessor = BASIC_WEEK_DATE_TIME.withLocale(Locale.getDefault()).parse(string);
                                                        Year year = Year.from(temporalAccessor);
                                                        MonthDay monthDay = MonthDay.from(temporalAccessor);
                                                        OffsetTime offsetTime = OffsetTime.from(temporalAccessor);
                                                        return GregorianCalendar.from(offsetTime.atDate(year.atMonthDay(monthDay)).atZoneSameInstant(ZoneId.systemDefault()));
                                                    }
                                                    catch (DateTimeParseException dateTimeParseException12) {
                                                        try {
                                                            LocalDate localDate = LocalDate.parse(string);
                                                            return GregorianCalendar.from(localDate.atStartOfDay(ZoneId.systemDefault()));
                                                        }
                                                        catch (DateTimeParseException dateTimeParseException13) {
                                                            try {
                                                                LocalDate localDate = LocalDate.parse(string, DateTimeFormatter.BASIC_ISO_DATE);
                                                                return GregorianCalendar.from(localDate.atStartOfDay(ZoneId.systemDefault()));
                                                            }
                                                            catch (DateTimeParseException dateTimeParseException14) {
                                                                try {
                                                                    LocalDate localDate = LocalDate.parse(string, DateTimeFormatter.ISO_ORDINAL_DATE);
                                                                    return GregorianCalendar.from(localDate.atStartOfDay(ZoneId.systemDefault()));
                                                                }
                                                                catch (DateTimeParseException dateTimeParseException15) {
                                                                    try {
                                                                        LocalDate localDate = BASIC_ORDINAL_DATE.parse((CharSequence)string, LocalDate::from);
                                                                        return GregorianCalendar.from(localDate.atStartOfDay(ZoneId.systemDefault()));
                                                                    }
                                                                    catch (DateTimeParseException dateTimeParseException16) {
                                                                        try {
                                                                            LocalDate localDate = LocalDate.parse(string, DateTimeFormatter.ISO_WEEK_DATE.withLocale(Locale.getDefault()));
                                                                            return GregorianCalendar.from(localDate.atStartOfDay(ZoneId.systemDefault()));
                                                                        }
                                                                        catch (DateTimeParseException dateTimeParseException17) {
                                                                            try {
                                                                                TemporalAccessor temporalAccessor = BASIC_WEEK_DATE.withLocale(Locale.getDefault()).parse(string);
                                                                                Year year = Year.from(temporalAccessor);
                                                                                MonthDay monthDay = MonthDay.from(temporalAccessor);
                                                                                return GregorianCalendar.from(year.atMonthDay(monthDay).atStartOfDay(ZoneId.systemDefault()));
                                                                            }
                                                                            catch (DateTimeParseException dateTimeParseException18) {
                                                                                try {
                                                                                    LocalDateTime localDateTime = STD_DATE_HOUR.parse((CharSequence)string, LocalDateTime::from);
                                                                                    return GregorianCalendar.from(localDateTime.atZone(ZoneId.systemDefault()));
                                                                                }
                                                                                catch (DateTimeParseException dateTimeParseException19) {
                                                                                    try {
                                                                                        LocalTime localTime = STD_HOUR.parse((CharSequence)string, LocalTime::from);
                                                                                        return GregorianCalendar.from(localTime.atDate(LocalDate.ofEpochDay(0L)).atZone(ZoneId.systemDefault()));
                                                                                    }
                                                                                    catch (DateTimeParseException dateTimeParseException20) {
                                                                                        try {
                                                                                            LocalTime localTime = LocalTime.parse(string);
                                                                                            return GregorianCalendar.from(localTime.atDate(LocalDate.ofEpochDay(0L)).atZone(ZoneId.systemDefault()));
                                                                                        }
                                                                                        catch (DateTimeParseException dateTimeParseException21) {
                                                                                            try {
                                                                                                YearMonth yearMonth = YearMonth.parse(string);
                                                                                                return GregorianCalendar.from(yearMonth.atDay(1).atStartOfDay(ZoneId.systemDefault()));
                                                                                            }
                                                                                            catch (DateTimeParseException dateTimeParseException22) {
                                                                                                try {
                                                                                                    Year year = Year.parse(string);
                                                                                                    return GregorianCalendar.from(year.atDay(1).atStartOfDay(ZoneId.systemDefault()));
                                                                                                }
                                                                                                catch (DateTimeParseException dateTimeParseException23) {
                                                                                                    try {
                                                                                                        TemporalAccessor temporalAccessor = STD_YEAR_WEEK.withLocale(Locale.getDefault()).parse(string);
                                                                                                        int n2 = temporalAccessor.get(WeekFields.ISO.weekBasedYear());
                                                                                                        int n3 = temporalAccessor.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
                                                                                                        return GregorianCalendar.from(LocalDateTime.from(temporalAccessor).with(WeekFields.ISO.weekOfYear(), n2).with(WeekFields.ISO.weekOfWeekBasedYear(), n3).atZone(ZoneId.systemDefault()));
                                                                                                    }
                                                                                                    catch (DateTimeParseException dateTimeParseException24) {
                                                                                                        ConversionException conversionException = new ConversionException("Cannot parse date");
                                                                                                        conversionException.add("date", string);
                                                                                                        throw conversionException;
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public String toString(Object object) {
        Calendar calendar = (Calendar)object;
        Instant instant = Instant.ofEpochMilli(calendar.getTimeInMillis());
        int n2 = calendar.getTimeZone().getOffset(calendar.getTimeInMillis());
        OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(instant, ZoneOffset.ofTotalSeconds(n2 / 1000));
        return STD_DATE_TIME.format(offsetDateTime);
    }
}

