/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import zz.org.joda.time.DateTime;
import zz.org.joda.time.DateTimeZone;
import zz.org.joda.time.format.DateTimeFormatter;
import zz.org.joda.time.format.ISODateTimeFormat;

public class ISO8601JodaTimeConverter
extends AbstractSingleValueConverter {
    private static final DateTimeFormatter[] formattersUTC = new DateTimeFormatter[]{ISODateTimeFormat.dateTime(), ISODateTimeFormat.dateTimeNoMillis(), ISODateTimeFormat.basicDateTime(), ISODateTimeFormat.basicDateTimeNoMillis(), ISODateTimeFormat.basicOrdinalDateTime(), ISODateTimeFormat.basicOrdinalDateTimeNoMillis(), ISODateTimeFormat.basicTime(), ISODateTimeFormat.basicTimeNoMillis(), ISODateTimeFormat.basicTTime(), ISODateTimeFormat.basicTTimeNoMillis(), ISODateTimeFormat.basicWeekDateTime(), ISODateTimeFormat.basicWeekDateTimeNoMillis(), ISODateTimeFormat.ordinalDateTime(), ISODateTimeFormat.ordinalDateTimeNoMillis(), ISODateTimeFormat.time(), ISODateTimeFormat.timeNoMillis(), ISODateTimeFormat.tTime(), ISODateTimeFormat.tTimeNoMillis(), ISODateTimeFormat.weekDateTime(), ISODateTimeFormat.weekDateTimeNoMillis()};
    private static final DateTimeFormatter[] formattersNoUTC = new DateTimeFormatter[]{ISODateTimeFormat.basicDate(), ISODateTimeFormat.basicOrdinalDate(), ISODateTimeFormat.basicWeekDate(), ISODateTimeFormat.date(), ISODateTimeFormat.dateHour(), ISODateTimeFormat.dateHourMinute(), ISODateTimeFormat.dateHourMinuteSecond(), ISODateTimeFormat.dateHourMinuteSecondFraction(), ISODateTimeFormat.dateHourMinuteSecondMillis(), ISODateTimeFormat.hour(), ISODateTimeFormat.hourMinute(), ISODateTimeFormat.hourMinuteSecond(), ISODateTimeFormat.hourMinuteSecondFraction(), ISODateTimeFormat.hourMinuteSecondMillis(), ISODateTimeFormat.ordinalDate(), ISODateTimeFormat.weekDate(), ISODateTimeFormat.year(), ISODateTimeFormat.yearMonth(), ISODateTimeFormat.yearMonthDay(), ISODateTimeFormat.weekyear(), ISODateTimeFormat.weekyearWeek(), ISODateTimeFormat.weekyearWeekDay()};

    public boolean canConvert(Class clazz) {
        return false;
    }

    public Object fromString(String string) {
        for (int i2 = 0; i2 < formattersUTC.length; ++i2) {
            DateTimeFormatter dateTimeFormatter = formattersUTC[i2];
            try {
                DateTime dateTime = dateTimeFormatter.parseDateTime(string);
                GregorianCalendar gregorianCalendar = dateTime.toGregorianCalendar();
                ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getDefault());
                return gregorianCalendar;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault());
        for (int i3 = 0; i3 < formattersNoUTC.length; ++i3) {
            DateTimeFormatter dateTimeFormatter = formattersNoUTC[i3];
            try {
                DateTimeFormatter dateTimeFormatter2 = dateTimeFormatter.withZone(dateTimeZone);
                DateTime dateTime = dateTimeFormatter2.parseDateTime(string);
                GregorianCalendar gregorianCalendar = dateTime.toGregorianCalendar();
                ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getDefault());
                return gregorianCalendar;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        ConversionException conversionException = new ConversionException("Cannot parse date");
        conversionException.add("date", string);
        throw conversionException;
    }

    public String toString(Object object) {
        DateTime dateTime = new DateTime(object);
        return dateTime.toString(formattersUTC[0]);
    }
}

