/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class ObjectIdDictionary {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public void associateId(Object object, Object object2) {
        this.map.put(new WeakIdWrapper(object), object2);
        this.cleanup();
    }

    public Object lookupId(Object object) {
        Object v2 = this.map.get(new IdWrapper(object));
        return v2;
    }

    public boolean containsId(Object object) {
        boolean bl2 = this.map.containsKey(new IdWrapper(object));
        return bl2;
    }

    public void removeId(Object object) {
        this.map.remove(new IdWrapper(object));
        this.cleanup();
    }

    public int size() {
        this.cleanup();
        return this.map.size();
    }

    private void cleanup() {
        WeakIdWrapper weakIdWrapper;
        while ((weakIdWrapper = (WeakIdWrapper)this.queue.poll()) != null) {
            this.map.remove(weakIdWrapper);
        }
    }

    private class WeakIdWrapper
    extends WeakReference
    implements Wrapper {
        private final int hashCode;

        public WeakIdWrapper(Object object) {
            super(object, ObjectIdDictionary.this.queue);
            this.hashCode = System.identityHashCode(object);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            return this.get() == ((Wrapper)object).get();
        }

        public String toString() {
            Object t2 = this.get();
            return t2 == null ? "(null)" : t2.toString();
        }
    }

    private static class IdWrapper
    implements Wrapper {
        private final Object obj;
        private final int hashCode;

        public IdWrapper(Object object) {
            this.hashCode = System.identityHashCode(object);
            this.obj = object;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            return this.obj == ((Wrapper)object).get();
        }

        public String toString() {
            return this.obj.toString();
        }

        public Object get() {
            return this.obj;
        }
    }

    private static interface Wrapper {
        public int hashCode();

        public boolean equals(Object var1);

        public String toString();

        public Object get();
    }
}

