/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class PrioritizedList {
    private final Set set = new TreeSet();
    private int lowestPriority = Integer.MAX_VALUE;
    private int lastId = 0;

    public void add(Object object, int n2) {
        if (this.lowestPriority > n2) {
            this.lowestPriority = n2;
        }
        this.set.add(new PrioritizedItem(object, n2, ++this.lastId));
    }

    public Iterator iterator() {
        return new PrioritizedItemIterator(this.set.iterator());
    }

    private static class PrioritizedItemIterator
    implements Iterator {
        private Iterator iterator;

        public PrioritizedItemIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return ((PrioritizedItem)this.iterator.next()).value;
        }
    }

    private static class PrioritizedItem
    implements Comparable {
        final Object value;
        final int priority;
        final int id;

        public PrioritizedItem(Object object, int n2, int n3) {
            this.value = object;
            this.priority = n2;
            this.id = n3;
        }

        public int compareTo(Object object) {
            PrioritizedItem prioritizedItem = (PrioritizedItem)object;
            if (this.priority != prioritizedItem.priority) {
                return prioritizedItem.priority - this.priority;
            }
            return prioritizedItem.id - this.id;
        }

        public boolean equals(Object object) {
            return this.id == ((PrioritizedItem)object).id;
        }
    }
}

