/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.io.IOException;
import java.io.Writer;
import zz.com.thoughtworks.xstream.io.StreamException;

public class QuickWriter {
    private final Writer writer;
    private char[] buffer;
    private int pointer;

    public QuickWriter(Writer writer) {
        this(writer, 1024);
    }

    public QuickWriter(Writer writer, int n2) {
        this.writer = writer;
        this.buffer = new char[n2];
    }

    public void write(String string) {
        int n2 = string.length();
        if (this.pointer + n2 >= this.buffer.length) {
            this.flush();
            if (n2 > this.buffer.length) {
                this.raw(string.toCharArray());
                return;
            }
        }
        string.getChars(0, n2, this.buffer, this.pointer);
        this.pointer += n2;
    }

    public void write(char c2) {
        if (this.pointer + 1 >= this.buffer.length) {
            this.flush();
            if (this.buffer.length == 0) {
                this.raw(c2);
                return;
            }
        }
        this.buffer[this.pointer++] = c2;
    }

    public void write(char[] cArray) {
        int n2 = cArray.length;
        if (this.pointer + n2 >= this.buffer.length) {
            this.flush();
            if (n2 > this.buffer.length) {
                this.raw(cArray);
                return;
            }
        }
        System.arraycopy(cArray, 0, this.buffer, this.pointer, n2);
        this.pointer += n2;
    }

    public void flush() {
        try {
            this.writer.write(this.buffer, 0, this.pointer);
            this.pointer = 0;
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void close() {
        try {
            this.writer.write(this.buffer, 0, this.pointer);
            this.pointer = 0;
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    private void raw(char[] cArray) {
        try {
            this.writer.write(cArray);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    private void raw(char c2) {
        try {
            this.writer.write(c2);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }
}

