/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class SelfStreamingInstanceChecker
implements Converter {
    private final Object self;
    private Converter defaultConverter;
    private final ConverterLookup lookup;

    public SelfStreamingInstanceChecker(ConverterLookup converterLookup, Object object) {
        this.lookup = converterLookup;
        this.self = object;
    }

    public SelfStreamingInstanceChecker(Converter converter, Object object) {
        this.defaultConverter = converter;
        this.self = object;
        this.lookup = null;
    }

    public boolean canConvert(Class clazz) {
        return clazz == this.self.getClass();
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        if (object == this.self) {
            throw new ConversionException("Cannot marshal the XStream instance in action");
        }
        this.getConverter().marshal(object, hierarchicalStreamWriter, marshallingContext);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return this.getConverter().unmarshal(hierarchicalStreamReader, unmarshallingContext);
    }

    private Converter getConverter() {
        return this.defaultConverter != null ? this.defaultConverter : this.lookup.lookupConverterForType(Object.class);
    }
}

