/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.core.util.FastField;

public class SerializationMembers
implements Caching {
    private static final Method NO_METHOD = new Object(){

        private void noMethod() {
        }
    }.getClass().getDeclaredMethods()[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_CLASSES = new Class[0];
    private static final Map NO_FIELDS = Collections.EMPTY_MAP;
    private static final int PERSISTENT_FIELDS_MODIFIER = 26;
    private static final FastField[] OBJECT_TYPE_FIELDS = new FastField[]{new FastField(Object.class, "readResolve"), new FastField(Object.class, "writeReplace"), new FastField(Object.class, "readObject"), new FastField(Object.class, "writeObject")};
    private Map declaredCache = Collections.synchronizedMap(new HashMap());
    private Map resRepCache = Collections.synchronizedMap(new HashMap());
    private final Map fieldCache = Collections.synchronizedMap(new HashMap());

    public SerializationMembers() {
        int n2;
        for (n2 = 0; n2 < OBJECT_TYPE_FIELDS.length; ++n2) {
            this.declaredCache.put(OBJECT_TYPE_FIELDS[n2], NO_METHOD);
        }
        for (n2 = 0; n2 < 2; ++n2) {
            this.resRepCache.put(OBJECT_TYPE_FIELDS[n2], NO_METHOD);
        }
    }

    public Object callReadResolve(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Method method = this.getRRMethod(clazz, "readResolve");
        if (method != null) {
            ErrorWritingException errorWritingException = null;
            try {
                return method.invoke(object, EMPTY_ARGS);
            }
            catch (IllegalAccessException illegalAccessException) {
                errorWritingException = new ObjectAccessException("Cannot access method", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                errorWritingException = new ConversionException("Failed calling method", invocationTargetException.getTargetException());
            }
            errorWritingException.add("method", clazz.getName() + ".readResolve()");
            throw errorWritingException;
        }
        return object;
    }

    public Object callWriteReplace(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Method method = this.getRRMethod(clazz, "writeReplace");
        if (method != null) {
            ErrorWritingException errorWritingException = null;
            try {
                Object object2 = method.invoke(object, EMPTY_ARGS);
                if (object2 != null && !object.getClass().equals(object2.getClass())) {
                    object2 = this.callWriteReplace(object2);
                }
                return object2;
            }
            catch (IllegalAccessException illegalAccessException) {
                errorWritingException = new ObjectAccessException("Cannot access method", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                errorWritingException = new ConversionException("Failed calling method", invocationTargetException.getTargetException());
            }
            catch (ErrorWritingException errorWritingException2) {
                errorWritingException = errorWritingException2;
            }
            errorWritingException.add("method", clazz.getName() + ".writeReplace()");
            throw errorWritingException;
        }
        return object;
    }

    public boolean supportsReadObject(Class clazz, boolean bl2) {
        return this.getMethod(clazz, "readObject", new Class[]{ObjectInputStream.class}, bl2) != null;
    }

    public void callReadObject(Class clazz, Object object, ObjectInputStream objectInputStream) {
        ErrorWritingException errorWritingException = null;
        try {
            Method method = this.getMethod(clazz, "readObject", new Class[]{ObjectInputStream.class}, false);
            method.invoke(object, objectInputStream);
        }
        catch (IllegalAccessException illegalAccessException) {
            errorWritingException = new ObjectAccessException("Cannot access method", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            errorWritingException = new ConversionException("Failed calling method", invocationTargetException.getTargetException());
        }
        if (errorWritingException != null) {
            errorWritingException.add("method", object.getClass().getName() + ".readObject()");
            throw errorWritingException;
        }
    }

    public boolean supportsWriteObject(Class clazz, boolean bl2) {
        return this.getMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class}, bl2) != null;
    }

    public void callWriteObject(Class clazz, Object object, ObjectOutputStream objectOutputStream) {
        ErrorWritingException errorWritingException = null;
        try {
            Method method = this.getMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class}, false);
            method.invoke(object, objectOutputStream);
        }
        catch (IllegalAccessException illegalAccessException) {
            errorWritingException = new ObjectAccessException("Cannot access method", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            errorWritingException = new ConversionException("Failed calling method", invocationTargetException.getTargetException());
        }
        if (errorWritingException != null) {
            errorWritingException.add("method", object.getClass().getName() + ".writeObject()");
            throw errorWritingException;
        }
    }

    private Method getMethod(Class clazz, String string, Class[] classArray, boolean bl2) {
        Method method = this.getMethod(clazz, string, classArray);
        return method == NO_METHOD || !bl2 && !method.getDeclaringClass().equals(clazz) ? null : method;
    }

    private Method getMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            return null;
        }
        FastField fastField = new FastField(clazz, string);
        Method method = (Method)this.declaredCache.get(fastField);
        if (method == null) {
            try {
                method = clazz.getDeclaredMethod(string, classArray);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = this.getMethod(clazz.getSuperclass(), string, classArray);
            }
            this.declaredCache.put(fastField, method);
        }
        return method;
    }

    private Method getRRMethod(Class clazz, String string) {
        FastField fastField = new FastField(clazz, string);
        Method method = (Method)this.resRepCache.get(fastField);
        if (method == null) {
            method = this.getMethod(clazz, string, EMPTY_CLASSES, true);
            if (method != null && method.getDeclaringClass() != clazz) {
                if ((method.getModifiers() & 5) == 0 && ((method.getModifiers() & 2) > 0 || clazz.getPackage() != method.getDeclaringClass().getPackage())) {
                    method = NO_METHOD;
                }
            } else if (method == null) {
                method = NO_METHOD;
            }
            this.resRepCache.put(fastField, method);
        }
        return method == NO_METHOD ? null : method;
    }

    public Map getSerializablePersistentFields(Class clazz) {
        if (clazz == null) {
            return null;
        }
        HashMap<String, ObjectStreamField> hashMap = (HashMap<String, ObjectStreamField>)this.fieldCache.get(clazz.getName());
        if (hashMap == null) {
            ErrorWritingException errorWritingException = null;
            try {
                Field field = clazz.getDeclaredField("serialPersistentFields");
                if ((field.getModifiers() & 0x1A) == 26) {
                    field.setAccessible(true);
                    ObjectStreamField[] objectStreamFieldArray = (ObjectStreamField[])field.get(null);
                    if (objectStreamFieldArray != null) {
                        hashMap = new HashMap<String, ObjectStreamField>();
                        for (int i2 = 0; i2 < objectStreamFieldArray.length; ++i2) {
                            hashMap.put(objectStreamFieldArray[i2].getName(), objectStreamFieldArray[i2]);
                        }
                    }
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                errorWritingException = new ObjectAccessException("Cannot get field", illegalAccessException);
            }
            catch (ClassCastException classCastException) {
                errorWritingException = new ConversionException("Incompatible field type", classCastException);
            }
            if (errorWritingException != null) {
                errorWritingException.add("field", clazz.getName() + ".serialPersistentFields");
                throw errorWritingException;
            }
            if (hashMap == null) {
                hashMap = NO_FIELDS;
            }
            this.fieldCache.put(clazz.getName(), hashMap);
        }
        return hashMap == NO_FIELDS ? null : hashMap;
    }

    public void flushCache() {
        this.declaredCache.keySet().retainAll(Arrays.asList(OBJECT_TYPE_FIELDS));
        this.resRepCache.keySet().retainAll(Arrays.asList(OBJECT_TYPE_FIELDS));
    }
}

