/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.beans.PropertyEditor;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.util.Pool;

public class ThreadSafePropertyEditor {
    private final Class editorType;
    private final Pool pool;

    public ThreadSafePropertyEditor(Class clazz, int n2, int n3) {
        if (!PropertyEditor.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a " + PropertyEditor.class.getName());
        }
        this.editorType = clazz;
        this.pool = new Pool(n2, n3, new Pool.Factory(){

            public Object newInstance() {
                ErrorWritingException errorWritingException = null;
                try {
                    return ThreadSafePropertyEditor.this.editorType.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    errorWritingException = new ConversionException("Faild to call default constructor", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorWritingException = new ObjectAccessException("Cannot call default constructor", illegalAccessException);
                }
                errorWritingException.add("construction-type", ThreadSafePropertyEditor.this.editorType.getName());
                throw errorWritingException;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsText(Object object) {
        PropertyEditor propertyEditor = this.fetchFromPool();
        try {
            propertyEditor.setValue(object);
            String string = propertyEditor.getAsText();
            return string;
        }
        finally {
            this.pool.putInPool(propertyEditor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAsText(String string) {
        PropertyEditor propertyEditor = this.fetchFromPool();
        try {
            propertyEditor.setAsText(string);
            Object object = propertyEditor.getValue();
            return object;
        }
        finally {
            this.pool.putInPool(propertyEditor);
        }
    }

    private PropertyEditor fetchFromPool() {
        PropertyEditor propertyEditor = (PropertyEditor)this.pool.fetchFromPool();
        return propertyEditor;
    }
}

