/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import zz.com.thoughtworks.xstream.core.util.Pool;

public class ThreadSafeSimpleDateFormat {
    private final String formatString;
    private final Pool pool;
    private final TimeZone timeZone;

    public ThreadSafeSimpleDateFormat(String string, TimeZone timeZone, int n2, int n3, boolean bl2) {
        this(string, timeZone, Locale.ENGLISH, n2, n3, bl2);
    }

    public ThreadSafeSimpleDateFormat(String string, TimeZone timeZone, final Locale locale, int n2, int n3, final boolean bl2) {
        this.formatString = string;
        this.timeZone = timeZone;
        this.pool = new Pool(n2, n3, new Pool.Factory(){

            public Object newInstance() {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ThreadSafeSimpleDateFormat.this.formatString, locale);
                simpleDateFormat.setLenient(bl2);
                return simpleDateFormat;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        DateFormat dateFormat = this.fetchFromPool();
        try {
            String string = dateFormat.format(date);
            return string;
        }
        finally {
            this.pool.putInPool(dateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String string) throws ParseException {
        DateFormat dateFormat = this.fetchFromPool();
        try {
            Date date = dateFormat.parse(string);
            return date;
        }
        finally {
            this.pool.putInPool(dateFormat);
        }
    }

    private DateFormat fetchFromPool() {
        TimeZone timeZone;
        DateFormat dateFormat = (DateFormat)this.pool.fetchFromPool();
        TimeZone timeZone2 = timeZone = this.timeZone != null ? this.timeZone : TimeZone.getDefault();
        if (!timeZone.equals(dateFormat.getTimeZone())) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public String toString() {
        return this.formatString;
    }
}

