/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakCache
extends AbstractMap {
    private final Map map;

    public WeakCache() {
        this(new WeakHashMap());
    }

    public WeakCache(Map map) {
        this.map = map;
    }

    public Object get(Object object) {
        Reference reference = (Reference)this.map.get(object);
        return reference != null ? reference.get() : null;
    }

    public Object put(Object object, Object object2) {
        Reference reference = this.map.put(object, this.createReference(object2));
        return reference == null ? null : reference.get();
    }

    public Object remove(Object object) {
        Reference reference = (Reference)this.map.remove(object);
        return reference == null ? null : reference.get();
    }

    protected Reference createReference(Object object) {
        return new WeakReference<Object>(object);
    }

    public boolean containsValue(final Object object) {
        Boolean bl2 = (Boolean)this.iterate(new Visitor(){

            public Object visit(Object object2) {
                return object2.equals(object) ? Boolean.TRUE : null;
            }
        }, 0);
        return bl2 == Boolean.TRUE;
    }

    public int size() {
        if (this.map.size() == 0) {
            return 0;
        }
        final int[] nArray = new int[]{0};
        this.iterate(new Visitor(){

            public Object visit(Object object) {
                nArray[0] = nArray[0] + 1;
                return null;
            }
        }, 0);
        return nArray[0];
    }

    public Collection values() {
        final ArrayList arrayList = new ArrayList();
        if (this.map.size() != 0) {
            this.iterate(new Visitor(){

                public Object visit(Object object) {
                    arrayList.add(object);
                    return null;
                }
            }, 0);
        }
        return arrayList;
    }

    public Set entrySet() {
        final HashSet hashSet = new HashSet();
        if (this.map.size() != 0) {
            this.iterate(new Visitor(){

                public Object visit(Object object) {
                    final Map.Entry entry = (Map.Entry)object;
                    hashSet.add(new Map.Entry(){

                        public Object getKey() {
                            return entry.getKey();
                        }

                        public Object getValue() {
                            return ((Reference)entry.getValue()).get();
                        }

                        public Object setValue(Object object) {
                            Reference reference = entry.setValue(WeakCache.this.createReference(object));
                            return reference != null ? reference.get() : null;
                        }
                    });
                    return null;
                }
            }, 2);
        }
        return hashSet;
    }

    private Object iterate(Visitor visitor, int n2) {
        Object object = null;
        Iterator iterator = this.map.entrySet().iterator();
        while (object == null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Reference reference = (Reference)entry.getValue();
            Object t2 = reference.get();
            if (t2 == null) {
                iterator.remove();
                continue;
            }
            switch (n2) {
                case 0: {
                    object = visitor.visit(t2);
                    break;
                }
                case 1: {
                    object = visitor.visit(entry.getKey());
                    break;
                }
                case 2: {
                    object = visitor.visit(entry);
                }
            }
        }
        return object;
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    private static interface Visitor {
        public Object visit(Object var1);
    }
}

