/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class XmlHeaderAwareReader
extends Reader {
    private final InputStreamReader reader;
    private final double version;
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_VERSION = "version";
    private static final String XML_TOKEN = "?xml";
    private static final int STATE_BOM = 0;
    private static final int STATE_START = 1;
    private static final int STATE_AWAIT_XML_HEADER = 2;
    private static final int STATE_ATTR_NAME = 3;
    private static final int STATE_ATTR_VALUE = 4;

    public XmlHeaderAwareReader(InputStream inputStream) throws UnsupportedEncodingException, IOException {
        PushbackInputStream[] pushbackInputStreamArray = new PushbackInputStream[]{inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, 64)};
        Map map = this.getHeader(pushbackInputStreamArray);
        this.version = Double.parseDouble((String)map.get(KEY_VERSION));
        this.reader = new InputStreamReader((InputStream)pushbackInputStreamArray[0], (String)map.get(KEY_ENCODING));
    }

    private Map getHeader(PushbackInputStream[] pushbackInputStreamArray) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(KEY_ENCODING, "utf-8");
        hashMap.put(KEY_VERSION, "1.0");
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        int n3 = 0;
        char c2 = '\u0000';
        char c3 = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl2 = false;
        while (n3 != -1 && (n3 = pushbackInputStreamArray[0].read()) != -1) {
            byteArrayOutputStream.write(n3);
            c2 = (char)n3;
            switch (n2) {
                case 0: {
                    if (c2 == '\u00ef' && byteArrayOutputStream.size() == 1 || c2 == '\u00bb' && byteArrayOutputStream.size() == 2 || c2 == '\u00bf' && byteArrayOutputStream.size() == 3) {
                        if (c2 != '\u00bf') break;
                        byteArrayOutputStream.reset();
                        n2 = 1;
                        break;
                    }
                    if (byteArrayOutputStream.size() > 1) {
                        n3 = -1;
                        break;
                    }
                    n2 = 1;
                }
                case 1: {
                    if (Character.isWhitespace(c2)) break;
                    if (c2 == '<') {
                        n2 = 2;
                        break;
                    }
                    n3 = -1;
                    break;
                }
                case 2: {
                    if (!Character.isWhitespace(c2)) {
                        stringBuffer.append(Character.toLowerCase(c2));
                        if (XML_TOKEN.startsWith(stringBuffer.substring(0))) break;
                        n3 = -1;
                        break;
                    }
                    if (stringBuffer.toString().equals(XML_TOKEN)) {
                        n2 = 3;
                        stringBuffer.setLength(0);
                        break;
                    }
                    n3 = -1;
                    break;
                }
                case 3: {
                    if (!Character.isWhitespace(c2)) {
                        if (c2 == '=') {
                            n2 = 4;
                            break;
                        }
                        if (Character.isLetter(c2 = Character.toLowerCase(c2))) {
                            stringBuffer.append(c2);
                            break;
                        }
                        n3 = -1;
                        break;
                    }
                    if (stringBuffer.length() <= 0) break;
                    n3 = -1;
                    break;
                }
                case 4: {
                    if (c3 == '\u0000') {
                        if (c2 == '\"' || c2 == '\'') {
                            c3 = c2;
                            break;
                        }
                        n3 = -1;
                        break;
                    }
                    if (c2 == '\\' && !bl2) {
                        bl2 = true;
                        break;
                    }
                    if (c2 == c3 && !bl2) {
                        c3 = '\u0000';
                        n2 = 3;
                        hashMap.put(stringBuffer.toString(), stringBuffer2.toString());
                        stringBuffer.setLength(0);
                        stringBuffer2.setLength(0);
                        break;
                    }
                    bl2 = false;
                    if (c2 != '\n') {
                        stringBuffer2.append(c2);
                        break;
                    }
                    n3 = -1;
                }
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        n3 = byArray.length;
        while (n3-- > 0) {
            byte by2 = byArray[n3];
            try {
                pushbackInputStreamArray[0].unread(by2);
            }
            catch (IOException iOException) {
                pushbackInputStreamArray[0] = new PushbackInputStream(pushbackInputStreamArray[0], ++n3);
            }
        }
        return hashMap;
    }

    public String getEncoding() {
        return this.reader.getEncoding();
    }

    public double getVersion() {
        return this.version;
    }

    public void mark(int n2) throws IOException {
        this.reader.mark(n2);
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public int read() throws IOException {
        return this.reader.read();
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        return this.reader.read(cArray, n2, n3);
    }

    public int read(char[] cArray) throws IOException {
        return this.reader.read(cArray);
    }

    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public long skip(long l2) throws IOException {
        return this.reader.skip(l2);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean equals(Object object) {
        return this.reader.equals(object);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    public String toString() {
        return this.reader.toString();
    }
}

