/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import zz.com.thoughtworks.xstream.core.util.FastStack;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.WriterWrapper;

public class StatefulWriter
extends WriterWrapper {
    public static int STATE_OPEN = 0;
    public static int STATE_NODE_START = 1;
    public static int STATE_VALUE = 2;
    public static int STATE_NODE_END = 3;
    public static int STATE_CLOSED = 4;
    private transient int state = STATE_OPEN;
    private transient int balance;
    private transient FastStack attributes = new FastStack(16);

    public StatefulWriter(HierarchicalStreamWriter hierarchicalStreamWriter) {
        super(hierarchicalStreamWriter);
    }

    public void startNode(String string) {
        this.startNodeCommon();
        super.startNode(string);
    }

    public void startNode(String string, Class clazz) {
        this.startNodeCommon();
        super.startNode(string, clazz);
    }

    private void startNodeCommon() {
        this.checkClosed();
        if (this.state == STATE_VALUE) {
            throw new StreamException(new IllegalStateException("Opening node after writing text"));
        }
        this.state = STATE_NODE_START;
        ++this.balance;
        this.attributes.push(new HashSet());
    }

    public void addAttribute(String string, String string2) {
        this.checkClosed();
        if (this.state != STATE_NODE_START) {
            throw new StreamException(new IllegalStateException("Writing attribute '" + string + "' without an opened node"));
        }
        Set set = (Set)this.attributes.peek();
        if (set.contains(string)) {
            throw new StreamException(new IllegalStateException("Writing attribute '" + string + "' twice"));
        }
        set.add(string);
        super.addAttribute(string, string2);
    }

    public void setValue(String string) {
        this.checkClosed();
        if (this.state != STATE_NODE_START) {
            throw new StreamException(new IllegalStateException("Writing text without an opened node"));
        }
        this.state = STATE_VALUE;
        super.setValue(string);
    }

    public void endNode() {
        this.checkClosed();
        if (this.balance-- == 0) {
            throw new StreamException(new IllegalStateException("Unbalanced node"));
        }
        this.attributes.popSilently();
        this.state = STATE_NODE_END;
        super.endNode();
    }

    public void flush() {
        this.checkClosed();
        super.flush();
    }

    public void close() {
        if (this.state == STATE_NODE_END || this.state != STATE_OPEN) {
            // empty if block
        }
        this.state = STATE_CLOSED;
        super.close();
    }

    private void checkClosed() {
        if (this.state == STATE_CLOSED) {
            throw new StreamException(new IOException("Writing on a closed stream"));
        }
    }

    public int state() {
        return this.state;
    }

    private Object readResolve() {
        this.attributes = new FastStack(16);
        return this;
    }
}

