/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.binary;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.ErrorWriter;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.binary.ReaderDepthState;
import zz.com.thoughtworks.xstream.io.binary.Token;

public class BinaryStreamReader
implements ExtendedHierarchicalStreamReader {
    private final DataInputStream in;
    private final ReaderDepthState depthState = new ReaderDepthState();
    private final IdRegistry idRegistry = new IdRegistry();
    private Token pushback;
    private final Token.Formatter tokenFormatter = new Token.Formatter();

    public BinaryStreamReader(InputStream inputStream) {
        this.in = new DataInputStream(inputStream);
        this.moveDown();
    }

    public boolean hasMoreChildren() {
        return this.depthState.hasMoreChildren();
    }

    public String getNodeName() {
        return this.depthState.getName();
    }

    public String getValue() {
        return this.depthState.getValue();
    }

    public String getAttribute(String string) {
        return this.depthState.getAttribute(string);
    }

    public String getAttribute(int n2) {
        return this.depthState.getAttribute(n2);
    }

    public int getAttributeCount() {
        return this.depthState.getAttributeCount();
    }

    public String getAttributeName(int n2) {
        return this.depthState.getAttributeName(n2);
    }

    public Iterator getAttributeNames() {
        return this.depthState.getAttributeNames();
    }

    public void moveDown() {
        Token token;
        this.depthState.push();
        Token token2 = this.readToken();
        switch (token2.getType()) {
            case 3: {
                this.depthState.setName(this.idRegistry.get(token2.getId()));
                break;
            }
            default: {
                throw new StreamException("Expected StartNode");
            }
        }
        block9: while (true) {
            token = this.readToken();
            switch (token.getType()) {
                case 5: {
                    this.depthState.addAttribute(this.idRegistry.get(token.getId()), token.getValue());
                    continue block9;
                }
                case 6: {
                    this.depthState.setValue(token.getValue());
                    continue block9;
                }
                case 4: {
                    this.depthState.setHasMoreChildren(false);
                    this.pushBack(token);
                    return;
                }
                case 3: {
                    this.depthState.setHasMoreChildren(true);
                    this.pushBack(token);
                    return;
                }
            }
            break;
        }
        throw new StreamException("Unexpected token " + token);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void moveUp() {
        Token token;
        this.depthState.pop();
        int n2 = 0;
        block8: while (true) {
            token = this.readToken();
            switch (token.getType()) {
                case 4: {
                    if (n2 == 0) break block8;
                    --n2;
                    break;
                }
                case 3: {
                    ++n2;
                }
            }
        }
        token = this.readToken();
        switch (token.getType()) {
            case 4: {
                this.depthState.setHasMoreChildren(false);
                break;
            }
            case 3: {
                this.depthState.setHasMoreChildren(true);
                break;
            }
            default: {
                throw new StreamException("Unexpected token " + token);
            }
        }
        this.pushBack(token);
    }

    private Token readToken() {
        if (this.pushback == null) {
            try {
                Token token = this.tokenFormatter.read(this.in);
                switch (token.getType()) {
                    case 2: {
                        this.idRegistry.put(token.getId(), token.getValue());
                        return this.readToken();
                    }
                }
                return token;
            }
            catch (IOException iOException) {
                throw new StreamException(iOException);
            }
        }
        Token token = this.pushback;
        this.pushback = null;
        return token;
    }

    public void pushBack(Token token) {
        if (this.pushback != null) {
            throw new Error("Cannot push more than one token back");
        }
        this.pushback = token;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public String peekNextChild() {
        if (this.depthState.hasMoreChildren()) {
            return this.idRegistry.get(this.pushback.getId());
        }
        return null;
    }

    public HierarchicalStreamReader underlyingReader() {
        return this;
    }

    public void appendErrors(ErrorWriter errorWriter) {
    }

    private static class IdRegistry {
        private Map map = new HashMap();

        private IdRegistry() {
        }

        public void put(long l2, String string) {
            this.map.put(new Long(l2), string);
        }

        public String get(long l2) {
            String string = (String)this.map.get(new Long(l2));
            if (string == null) {
                throw new StreamException("Unknown ID : " + l2);
            }
            return string;
        }
    }
}

