/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.binary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.binary.Token;

public class BinaryStreamWriter
implements ExtendedHierarchicalStreamWriter {
    private final IdRegistry idRegistry = new IdRegistry();
    private final DataOutputStream out;
    private final Token.Formatter tokenFormatter = new Token.Formatter();

    public BinaryStreamWriter(OutputStream outputStream) {
        this.out = new DataOutputStream(outputStream);
    }

    public void startNode(String string) {
        this.write(new Token.StartNode(this.idRegistry.getId(string)));
    }

    public void startNode(String string, Class clazz) {
        this.startNode(string);
    }

    public void addAttribute(String string, String string2) {
        this.write(new Token.Attribute(this.idRegistry.getId(string), string2));
    }

    public void setValue(String string) {
        this.write(new Token.Value(string));
    }

    public void endNode() {
        this.write(new Token.EndNode());
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }

    private void write(Token token) {
        try {
            this.tokenFormatter.write(this.out, token);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    private class IdRegistry {
        private long nextId = 0L;
        private Map ids = new HashMap();

        private IdRegistry() {
        }

        public long getId(String string) {
            Long l2 = (Long)this.ids.get(string);
            if (l2 == null) {
                l2 = new Long(++this.nextId);
                this.ids.put(string, l2);
                BinaryStreamWriter.this.write(new Token.MapIdToValue(l2, string));
            }
            return l2;
        }
    }
}

