/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.binary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ReaderDepthState {
    private static final String EMPTY_STRING = "";
    private State current;

    ReaderDepthState() {
    }

    public void push() {
        State state = new State();
        state.parent = this.current;
        this.current = state;
    }

    public void pop() {
        this.current = this.current.parent;
    }

    public String getName() {
        return this.current.name;
    }

    public void setName(String string) {
        this.current.name = string;
    }

    public String getValue() {
        return this.current.value == null ? EMPTY_STRING : this.current.value;
    }

    public void setValue(String string) {
        this.current.value = string;
    }

    public boolean hasMoreChildren() {
        return this.current.hasMoreChildren;
    }

    public void setHasMoreChildren(boolean bl2) {
        this.current.hasMoreChildren = bl2;
    }

    public void addAttribute(String string, String string2) {
        Attribute attribute = new Attribute();
        attribute.name = string;
        attribute.value = string2;
        if (this.current.attributes == null) {
            this.current.attributes = new ArrayList();
        }
        this.current.attributes.add(attribute);
    }

    public String getAttribute(String string) {
        if (this.current.attributes == null) {
            return null;
        }
        for (Attribute attribute : this.current.attributes) {
            if (!attribute.name.equals(string)) continue;
            return attribute.value;
        }
        return null;
    }

    public String getAttribute(int n2) {
        if (this.current.attributes == null) {
            return null;
        }
        Attribute attribute = (Attribute)this.current.attributes.get(n2);
        return attribute.value;
    }

    public String getAttributeName(int n2) {
        if (this.current.attributes == null) {
            return null;
        }
        Attribute attribute = (Attribute)this.current.attributes.get(n2);
        return attribute.name;
    }

    public int getAttributeCount() {
        return this.current.attributes == null ? 0 : this.current.attributes.size();
    }

    public Iterator getAttributeNames() {
        if (this.current.attributes == null) {
            return Collections.EMPTY_SET.iterator();
        }
        final Iterator iterator = this.current.attributes.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                Attribute attribute = (Attribute)iterator.next();
                return attribute.name;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class Attribute {
        String name;
        String value;

        private Attribute() {
        }
    }

    private static class State {
        String name;
        String value;
        List attributes;
        boolean hasMoreChildren;
        State parent;

        private State() {
        }
    }
}

