/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import zz.com.thoughtworks.xstream.io.StreamException;

public abstract class Token {
    private static final byte TYPE_MASK = 7;
    public static final byte TYPE_VERSION = 1;
    public static final byte TYPE_MAP_ID_TO_VALUE = 2;
    public static final byte TYPE_START_NODE = 3;
    public static final byte TYPE_END_NODE = 4;
    public static final byte TYPE_ATTRIBUTE = 5;
    public static final byte TYPE_VALUE = 6;
    private static final byte ID_MASK = 56;
    private static final byte ID_ONE_BYTE = 8;
    private static final byte ID_TWO_BYTES = 16;
    private static final byte ID_FOUR_BYTES = 24;
    private static final byte ID_EIGHT_BYTES = 32;
    private static final String ID_SPLITTED = "\u0000\u2021\u0000";
    private static final int MAX_UTF8_LENGTH = 65535;
    private final byte type;
    protected long id = -1L;
    protected String value;

    public Token(byte by2) {
        this.type = by2;
    }

    public byte getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + " [id=" + this.id + ", value='" + this.value + "']";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Token token = (Token)object;
        if (this.id != token.id) {
            return false;
        }
        if (this.type != token.type) {
            return false;
        }
        return !(this.value == null ? token.value != null : !this.value.equals(token.value));
    }

    public int hashCode() {
        int n2 = this.type;
        n2 = 29 * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = 29 * n2 + (this.value != null ? this.value.hashCode() : 0);
        return n2;
    }

    public abstract void writeTo(DataOutput var1, byte var2) throws IOException;

    public abstract void readFrom(DataInput var1, byte var2) throws IOException;

    protected void writeId(DataOutput dataOutput, long l2, byte by2) throws IOException {
        if (l2 < 0L) {
            throw new IOException("id must not be negative " + l2);
        }
        switch (by2) {
            case 8: {
                dataOutput.writeByte((byte)l2 + -128);
                break;
            }
            case 16: {
                dataOutput.writeShort((short)l2 + Short.MIN_VALUE);
                break;
            }
            case 24: {
                dataOutput.writeInt((int)l2 + Integer.MIN_VALUE);
                break;
            }
            case 32: {
                dataOutput.writeLong(l2 + Long.MIN_VALUE);
                break;
            }
            default: {
                throw new Error("Unknown idType " + by2);
            }
        }
    }

    protected void writeString(DataOutput dataOutput, String string) throws IOException {
        byte[] byArray = string.length() > 16383 ? string.getBytes("utf-8") : new byte[]{};
        int n2 = byArray.length;
        if (n2 <= 65535) {
            dataOutput.writeUTF(string);
        } else {
            dataOutput.writeUTF(ID_SPLITTED);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
        }
    }

    protected long readId(DataInput dataInput, byte by2) throws IOException {
        switch (by2) {
            case 8: {
                return dataInput.readByte() - -128;
            }
            case 16: {
                return dataInput.readShort() - Short.MIN_VALUE;
            }
            case 24: {
                return dataInput.readInt() - Integer.MIN_VALUE;
            }
            case 32: {
                return dataInput.readLong() - Long.MIN_VALUE;
            }
        }
        throw new Error("Unknown idType " + by2);
    }

    protected String readString(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        if (!ID_SPLITTED.equals(string)) {
            return string;
        }
        int n2 = dataInput.readInt();
        byte[] byArray = new byte[n2];
        dataInput.readFully(byArray);
        return new String(byArray, "utf-8");
    }

    public static class Value
    extends Token {
        public Value(String string) {
            super((byte)6);
            this.value = string;
        }

        public Value() {
            super((byte)6);
        }

        public void writeTo(DataOutput dataOutput, byte by2) throws IOException {
            this.writeString(dataOutput, this.value);
        }

        public void readFrom(DataInput dataInput, byte by2) throws IOException {
            this.value = this.readString(dataInput);
        }
    }

    public static class Attribute
    extends Token {
        public Attribute(long l2, String string) {
            super((byte)5);
            this.id = l2;
            this.value = string;
        }

        public Attribute() {
            super((byte)5);
        }

        public void writeTo(DataOutput dataOutput, byte by2) throws IOException {
            this.writeId(dataOutput, this.id, by2);
            this.writeString(dataOutput, this.value);
        }

        public void readFrom(DataInput dataInput, byte by2) throws IOException {
            this.id = this.readId(dataInput, by2);
            this.value = this.readString(dataInput);
        }
    }

    public static class EndNode
    extends Token {
        public EndNode() {
            super((byte)4);
        }

        public void writeTo(DataOutput dataOutput, byte by2) {
        }

        public void readFrom(DataInput dataInput, byte by2) {
        }
    }

    public static class StartNode
    extends Token {
        public StartNode(long l2) {
            super((byte)3);
            this.id = l2;
        }

        public StartNode() {
            super((byte)3);
        }

        public void writeTo(DataOutput dataOutput, byte by2) throws IOException {
            this.writeId(dataOutput, this.id, by2);
        }

        public void readFrom(DataInput dataInput, byte by2) throws IOException {
            this.id = this.readId(dataInput, by2);
        }
    }

    public static class MapIdToValue
    extends Token {
        public MapIdToValue(long l2, String string) {
            super((byte)2);
            this.id = l2;
            this.value = string;
        }

        public MapIdToValue() {
            super((byte)2);
        }

        public void writeTo(DataOutput dataOutput, byte by2) throws IOException {
            this.writeId(dataOutput, this.id, by2);
            this.writeString(dataOutput, this.value);
        }

        public void readFrom(DataInput dataInput, byte by2) throws IOException {
            this.id = this.readId(dataInput, by2);
            this.value = this.readString(dataInput);
        }
    }

    public static class Formatter {
        public void write(DataOutput dataOutput, Token token) throws IOException {
            long l2 = token.getId();
            byte by2 = l2 <= 255L ? (byte)8 : (l2 <= 65535L ? (byte)16 : (l2 <= 0xFFFFFFFFL ? (byte)24 : 32));
            dataOutput.write(token.getType() + by2);
            token.writeTo(dataOutput, by2);
        }

        public Token read(DataInput dataInput) throws IOException {
            byte by2 = dataInput.readByte();
            byte by3 = (byte)(by2 & 7);
            byte by4 = (byte)(by2 & 0x38);
            Token token = this.contructToken(by3);
            token.readFrom(dataInput, by4);
            return token;
        }

        private Token contructToken(byte by2) {
            switch (by2) {
                case 3: {
                    return new StartNode();
                }
                case 2: {
                    return new MapIdToValue();
                }
                case 5: {
                    return new Attribute();
                }
                case 4: {
                    return new EndNode();
                }
                case 6: {
                    return new Value();
                }
            }
            throw new StreamException("Unknown token type");
        }
    }
}

