/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.json;

import java.io.Externalizable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.core.util.FastStack;
import zz.com.thoughtworks.xstream.io.AbstractWriter;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.naming.NoNameCoder;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public abstract class AbstractJsonWriter
extends AbstractWriter {
    public static final int DROP_ROOT_MODE = 1;
    public static final int STRICT_MODE = 2;
    public static final int EXPLICIT_MODE = 4;
    public static final int IEEE_754_MODE = 8;
    private static final int STATE_ROOT = 1;
    private static final int STATE_END_OBJECT = 2;
    private static final int STATE_START_OBJECT = 4;
    private static final int STATE_START_ATTRIBUTES = 8;
    private static final int STATE_NEXT_ATTRIBUTE = 16;
    private static final int STATE_END_ATTRIBUTES = 32;
    private static final int STATE_START_ELEMENTS = 64;
    private static final int STATE_NEXT_ELEMENT = 128;
    private static final int STATE_END_ELEMENTS = 256;
    private static final int STATE_SET_VALUE = 512;
    private static final Set NUMBER_TYPES = new HashSet<Class>(Arrays.asList(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigInteger.class, BigDecimal.class));
    private int mode;
    private FastStack stack = new FastStack(16);
    private int expectedStates;

    public AbstractJsonWriter() {
        this(new NoNameCoder());
    }

    public AbstractJsonWriter(int n2) {
        this(n2, new NoNameCoder());
    }

    public AbstractJsonWriter(NameCoder nameCoder) {
        this(0, nameCoder);
    }

    public AbstractJsonWriter(int n2, NameCoder nameCoder) {
        super(nameCoder);
        this.mode = (n2 & 4) > 0 ? 4 : n2;
        this.stack.push(new StackElement(null, 1));
        this.expectedStates = 4;
    }

    public void startNode(String string, Class clazz) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.stack.push(new StackElement(clazz, ((StackElement)this.stack.peek()).status));
        this.handleCheckedStateTransition(4, string, null);
        this.expectedStates = 661;
    }

    public void startNode(String string) {
        this.startNode(string, null);
    }

    public void addAttribute(String string, String string2) {
        this.handleCheckedStateTransition(16, string, string2);
        this.expectedStates = 661;
    }

    public void setValue(String string) {
        Class clazz = ((StackElement)this.stack.peek()).type;
        if ((clazz == Character.class || clazz == Character.TYPE) && "".equals(string)) {
            string = "\u0000";
        }
        this.handleCheckedStateTransition(512, null, string);
        this.expectedStates = 129;
    }

    public void endNode() {
        int n2 = this.stack.size();
        int n3 = n2 > 2 ? 128 : 1;
        this.handleCheckedStateTransition(n3, null, null);
        this.stack.pop();
        ((StackElement)this.stack.peek()).status = n3;
        this.expectedStates = 4;
        if (n2 > 2) {
            this.expectedStates |= 0x81;
        }
    }

    private void handleCheckedStateTransition(int n2, String string, String string2) {
        int n3;
        StackElement stackElement = (StackElement)this.stack.peek();
        if ((this.expectedStates & n2) == 0) {
            throw new IllegalWriterStateException(stackElement.status, n2, string);
        }
        stackElement.status = n3 = this.handleStateTransition(stackElement.status, n2, string, string2);
    }

    private int handleStateTransition(int n2, int n3, String string, String string2) {
        int n4 = this.stack.size();
        Class clazz = ((StackElement)this.stack.peek()).type;
        boolean bl2 = n4 > 1 && this.isArray(clazz);
        boolean bl3 = n4 > 1 && this.isArray(((StackElement)this.stack.get((int)(n4 - 2))).type);
        switch (n2) {
            case 1: {
                if (n3 == 4) {
                    n2 = this.handleStateTransition(64, 4, string, null);
                    return n3;
                }
                throw new IllegalWriterStateException(n2, n3, string);
            }
            case 2: {
                switch (n3) {
                    case 4: {
                        n2 = this.handleStateTransition(n2, 128, null, null);
                        n2 = this.handleStateTransition(n2, 4, string, null);
                        return n3;
                    }
                    case 128: {
                        this.nextElement();
                        return n3;
                    }
                    case 1: {
                        if (((this.mode & 1) == 0 || n4 > 2) && (this.mode & 4) == 0) {
                            this.endObject();
                        }
                        return n3;
                    }
                }
                throw new IllegalWriterStateException(n2, n3, string);
            }
            case 4: {
                switch (n3) {
                    case 1: 
                    case 4: 
                    case 128: 
                    case 512: {
                        if (!bl3 || (this.mode & 4) != 0) {
                            n2 = this.handleStateTransition(n2, 8, null, null);
                            n2 = this.handleStateTransition(n2, 32, null, null);
                        }
                        n2 = 64;
                        switch (n3) {
                            case 512: {
                                n2 = this.handleStateTransition(n2, 512, null, string2);
                                break;
                            }
                            case 4: {
                                n2 = this.handleStateTransition(n2, 4, string, null);
                                break;
                            }
                            case 1: 
                            case 128: {
                                n2 = this.handleStateTransition(n2, 512, null, null);
                                n2 = this.handleStateTransition(n2, n3, null, null);
                            }
                        }
                        return n3;
                    }
                    case 8: {
                        if ((this.mode & 4) != 0) {
                            this.startArray();
                        }
                        return n3;
                    }
                    case 16: {
                        if ((this.mode & 4) != 0 || !bl2) {
                            n2 = this.handleStateTransition(n2, 8, null, null);
                            n2 = this.handleStateTransition(n2, 16, string, string2);
                            return n3;
                        }
                        return 4;
                    }
                }
                throw new IllegalWriterStateException(n2, n3, string);
            }
            case 128: {
                switch (n3) {
                    case 4: {
                        this.nextElement();
                        if (bl3 || (this.mode & 4) != 0) break;
                        this.addLabel(this.encodeNode(string));
                        if ((this.mode & 4) == 0 && bl2) {
                            this.startArray();
                        }
                        return n3;
                    }
                    case 1: {
                        n2 = this.handleStateTransition(n2, 2, null, null);
                        n2 = this.handleStateTransition(n2, 1, null, null);
                        return n3;
                    }
                    case 2: 
                    case 128: {
                        n2 = this.handleStateTransition(n2, 256, null, null);
                        n2 = this.handleStateTransition(n2, 2, null, null);
                        if ((this.mode & 4) == 0 && !bl2) {
                            this.endObject();
                        }
                        return n3;
                    }
                    case 256: {
                        if ((this.mode & 4) == 0 && bl2) {
                            this.endArray();
                        }
                        return n3;
                    }
                    default: {
                        throw new IllegalWriterStateException(n2, n3, string);
                    }
                }
            }
            case 64: {
                switch (n3) {
                    case 4: {
                        if ((this.mode & 1) == 0 || n4 > 2) {
                            if (!bl3 || (this.mode & 4) != 0) {
                                if (!"".equals(string2)) {
                                    this.startObject();
                                }
                                this.addLabel(this.encodeNode(string));
                            }
                            if ((this.mode & 4) != 0) {
                                this.startArray();
                            }
                        }
                        if ((this.mode & 4) == 0 && bl2) {
                            this.startArray();
                        }
                        return n3;
                    }
                    case 512: {
                        if ((this.mode & 2) != 0 && n4 == 2) {
                            throw new ConversionException("Single value cannot be root element");
                        }
                        if (string2 == null) {
                            if (clazz == Mapper.Null.class) {
                                this.addValue("null", Type.NULL);
                            } else if ((this.mode & 4) == 0 && !bl2) {
                                this.startObject();
                                this.endObject();
                            }
                        } else if ((this.mode & 8) != 0 && (clazz == Long.TYPE || clazz == Long.class)) {
                            long l2 = Long.parseLong(string2);
                            if (l2 > 0x20000000000000L || l2 < -9007199254740992L) {
                                this.addValue(string2, Type.STRING);
                            } else {
                                this.addValue(string2, this.getType(clazz));
                            }
                        } else {
                            this.addValue(string2, this.getType(clazz));
                        }
                        return n3;
                    }
                    case 128: 
                    case 256: {
                        if ((this.mode & 4) == 0) {
                            if (bl2) {
                                this.endArray();
                            } else {
                                this.endObject();
                            }
                        }
                        return n3;
                    }
                }
                throw new IllegalWriterStateException(n2, n3, string);
            }
            case 256: {
                switch (n3) {
                    case 2: {
                        if ((this.mode & 4) != 0) {
                            this.endArray();
                            this.endArray();
                            this.endObject();
                        }
                        return n3;
                    }
                }
                throw new IllegalWriterStateException(n2, n3, string);
            }
            case 8: {
                switch (n3) {
                    case 16: {
                        if (string != null) {
                            String string3 = ((this.mode & 4) == 0 ? "@" : "") + string;
                            this.startObject();
                            this.addLabel(this.encodeAttribute(string3));
                            this.addValue(string2, Type.STRING);
                        }
                        return n3;
                    }
                }
            }
            case 16: {
                switch (n3) {
                    case 32: {
                        if ((this.mode & 4) != 0) {
                            if (n2 == 16) {
                                this.endObject();
                            }
                            this.endArray();
                            this.nextElement();
                            this.startArray();
                        }
                        return n3;
                    }
                    case 16: {
                        if (!bl2 || (this.mode & 4) != 0) {
                            this.nextElement();
                            String string4 = ((this.mode & 4) == 0 ? "@" : "") + string;
                            this.addLabel(this.encodeAttribute(string4));
                            this.addValue(string2, Type.STRING);
                        }
                        return n3;
                    }
                    case 4: 
                    case 512: {
                        n2 = this.handleStateTransition(n2, 32, null, null);
                        n2 = this.handleStateTransition(n2, 64, null, null);
                        switch (n3) {
                            case 512: {
                                if ((this.mode & 4) == 0) {
                                    this.addLabel(this.encodeNode("$"));
                                }
                                n2 = this.handleStateTransition(n2, 512, null, string2);
                                if ((this.mode & 4) != 0) break;
                                this.endObject();
                                break;
                            }
                            case 4: {
                                n2 = this.handleStateTransition(n2, 4, string, (this.mode & 4) == 0 ? "" : null);
                                break;
                            }
                            case 2: {
                                n2 = this.handleStateTransition(n2, 512, null, null);
                                n2 = this.handleStateTransition(n2, 2, null, null);
                            }
                        }
                        return n3;
                    }
                    case 128: {
                        n2 = this.handleStateTransition(n2, 32, null, null);
                        n2 = this.handleStateTransition(n2, 2, null, null);
                        return n3;
                    }
                    case 1: {
                        n2 = this.handleStateTransition(n2, 32, null, null);
                        n2 = this.handleStateTransition(n2, 2, null, null);
                        n2 = this.handleStateTransition(n2, 1, null, null);
                        return n3;
                    }
                }
                throw new IllegalWriterStateException(n2, n3, string);
            }
            case 32: {
                switch (n3) {
                    case 64: {
                        if ((this.mode & 4) != 0) break;
                        this.nextElement();
                        break;
                    }
                    case 2: {
                        n2 = this.handleStateTransition(64, 256, null, null);
                        n2 = this.handleStateTransition(n2, 2, null, null);
                        break;
                    }
                    default: {
                        throw new IllegalWriterStateException(n2, n3, string);
                    }
                }
                return n3;
            }
            case 512: {
                switch (n3) {
                    case 256: {
                        if ((this.mode & 4) == 0 && bl2) {
                            this.endArray();
                        }
                        return n3;
                    }
                    case 128: {
                        n2 = this.handleStateTransition(n2, 256, null, null);
                        n2 = this.handleStateTransition(n2, 2, null, null);
                        return n3;
                    }
                    case 1: {
                        n2 = this.handleStateTransition(n2, 256, null, null);
                        n2 = this.handleStateTransition(n2, 2, null, null);
                        n2 = this.handleStateTransition(n2, 1, null, null);
                        return n3;
                    }
                }
                throw new IllegalWriterStateException(n2, n3, string);
            }
        }
        throw new IllegalWriterStateException(n2, n3, string);
    }

    protected Type getType(Class clazz) {
        return clazz == Mapper.Null.class ? Type.NULL : (clazz == Boolean.class || clazz == Boolean.TYPE ? Type.BOOLEAN : (NUMBER_TYPES.contains(clazz) ? Type.NUMBER : Type.STRING));
    }

    protected boolean isArray(Class clazz) {
        return clazz != null && (clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Externalizable.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Map.Entry.class.isAssignableFrom(clazz));
    }

    protected abstract void startObject();

    protected abstract void addLabel(String var1);

    protected abstract void addValue(String var1, Type var2);

    protected abstract void startArray();

    protected abstract void nextElement();

    protected abstract void endArray();

    protected abstract void endObject();

    private static class IllegalWriterStateException
    extends IllegalStateException {
        public IllegalWriterStateException(int n2, int n3, String string) {
            super("Cannot turn from state " + IllegalWriterStateException.getState(n2) + " into state " + IllegalWriterStateException.getState(n3) + (string == null ? "" : " for property " + string));
        }

        private static String getState(int n2) {
            switch (n2) {
                case 1: {
                    return "ROOT";
                }
                case 2: {
                    return "END_OBJECT";
                }
                case 4: {
                    return "START_OBJECT";
                }
                case 8: {
                    return "START_ATTRIBUTES";
                }
                case 16: {
                    return "NEXT_ATTRIBUTE";
                }
                case 32: {
                    return "END_ATTRIBUTES";
                }
                case 64: {
                    return "START_ELEMENTS";
                }
                case 128: {
                    return "NEXT_ELEMENT";
                }
                case 256: {
                    return "END_ELEMENTS";
                }
                case 512: {
                    return "SET_VALUE";
                }
            }
            throw new IllegalArgumentException("Unknown state provided: " + n2 + ", cannot create message for IllegalWriterStateException");
        }
    }

    private static class StackElement {
        final Class type;
        int status;

        public StackElement(Class clazz, int n2) {
            this.type = clazz;
            this.status = n2;
        }
    }

    public static class Type {
        public static Type NULL = new Type();
        public static Type STRING = new Type();
        public static Type NUMBER = new Type();
        public static Type BOOLEAN = new Type();
    }
}

