/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.json;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import zz.com.thoughtworks.xstream.io.AbstractDriver;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.json.JettisonStaxWriter;
import zz.com.thoughtworks.xstream.io.xml.QNameMap;
import zz.com.thoughtworks.xstream.io.xml.StaxReader;
import zz.com.thoughtworks.xstream.io.xml.StaxWriter;
import zz.org.codehaus.jettison.mapped.Configuration;
import zz.org.codehaus.jettison.mapped.MappedNamespaceConvention;
import zz.org.codehaus.jettison.mapped.MappedXMLInputFactory;
import zz.org.codehaus.jettison.mapped.MappedXMLOutputFactory;

public class JettisonMappedXmlDriver
extends AbstractDriver {
    protected final MappedXMLOutputFactory mof;
    protected final MappedXMLInputFactory mif;
    protected final MappedNamespaceConvention convention;
    protected final boolean useSerializeAsArray;

    public JettisonMappedXmlDriver() {
        this(new Configuration());
    }

    public JettisonMappedXmlDriver(Configuration configuration) {
        this(configuration, true);
    }

    public JettisonMappedXmlDriver(Configuration configuration, boolean bl2) {
        this.mof = new MappedXMLOutputFactory(configuration);
        this.mif = new MappedXMLInputFactory(configuration);
        this.convention = new MappedNamespaceConvention(configuration);
        this.useSerializeAsArray = bl2;
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            return new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(reader), this.getNameCoder());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        try {
            return new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(inputStream), this.getNameCoder());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public HierarchicalStreamReader createReader(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            StaxReader staxReader = new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(uRL.toExternalForm(), inputStream), this.getNameCoder());
            return staxReader;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public HierarchicalStreamReader createReader(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            StaxReader staxReader = new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(file.toURI().toASCIIString(), (InputStream)fileInputStream), this.getNameCoder());
            return staxReader;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        try {
            if (this.useSerializeAsArray) {
                return new JettisonStaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(writer), this.getNameCoder(), this.convention);
            }
            return new StaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(writer), this.getNameCoder());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        try {
            if (this.useSerializeAsArray) {
                return new JettisonStaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(outputStream), this.getNameCoder(), this.convention);
            }
            return new StaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(outputStream), this.getNameCoder());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }
}

