/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.json;

import java.io.Writer;
import zz.com.thoughtworks.xstream.core.util.QuickWriter;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.json.AbstractJsonWriter;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.naming.NoNameCoder;

public class JsonWriter
extends AbstractJsonWriter {
    protected final QuickWriter writer;
    protected final Format format;
    private int depth;
    private boolean newLineProposed;

    public JsonWriter(Writer writer, char[] cArray, String string) {
        this(writer, 0, new Format(cArray, string.toCharArray(), Format.SPACE_AFTER_LABEL | Format.COMPACT_EMPTY_ELEMENT));
    }

    public JsonWriter(Writer writer, char[] cArray) {
        this(writer, 0, new Format(cArray, new char[]{'\n'}, Format.SPACE_AFTER_LABEL | Format.COMPACT_EMPTY_ELEMENT));
    }

    public JsonWriter(Writer writer, String string, String string2) {
        this(writer, 0, new Format(string.toCharArray(), string2.toCharArray(), Format.SPACE_AFTER_LABEL | Format.COMPACT_EMPTY_ELEMENT));
    }

    public JsonWriter(Writer writer, String string) {
        this(writer, 0, new Format(string.toCharArray(), new char[]{'\n'}, Format.SPACE_AFTER_LABEL | Format.COMPACT_EMPTY_ELEMENT));
    }

    public JsonWriter(Writer writer) {
        this(writer, 0, new Format(new char[]{' ', ' '}, new char[]{'\n'}, Format.SPACE_AFTER_LABEL | Format.COMPACT_EMPTY_ELEMENT));
    }

    public JsonWriter(Writer writer, char[] cArray, String string, int n2) {
        this(writer, n2, new Format(cArray, string.toCharArray(), Format.SPACE_AFTER_LABEL | Format.COMPACT_EMPTY_ELEMENT));
    }

    public JsonWriter(Writer writer, int n2) {
        this(writer, n2, new Format());
    }

    public JsonWriter(Writer writer, Format format) {
        this(writer, 0, format);
    }

    public JsonWriter(Writer writer, int n2, Format format) {
        this(writer, n2, format, 1024);
    }

    public JsonWriter(Writer writer, int n2, Format format, int n3) {
        super(n2, format.getNameCoder());
        this.writer = new QuickWriter(writer, n3);
        this.format = format;
        this.depth = (n2 & 1) == 0 ? -1 : 0;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }

    protected void startObject() {
        if (this.newLineProposed) {
            this.writeNewLine();
        }
        this.writer.write('{');
        this.startNewLine();
    }

    protected void addLabel(String string) {
        if (this.newLineProposed) {
            this.writeNewLine();
        }
        this.writer.write('\"');
        this.writeText(string);
        this.writer.write("\":");
        if ((this.format.mode() & Format.SPACE_AFTER_LABEL) != 0) {
            this.writer.write(' ');
        }
    }

    protected void addValue(String string, AbstractJsonWriter.Type type) {
        if (this.newLineProposed) {
            this.writeNewLine();
        }
        if (type == AbstractJsonWriter.Type.STRING) {
            this.writer.write('\"');
        }
        this.writeText(string);
        if (type == AbstractJsonWriter.Type.STRING) {
            this.writer.write('\"');
        }
    }

    protected void startArray() {
        if (this.newLineProposed) {
            this.writeNewLine();
        }
        this.writer.write("[");
        this.startNewLine();
    }

    protected void nextElement() {
        this.writer.write(",");
        this.writeNewLine();
    }

    protected void endArray() {
        this.endNewLine();
        this.writer.write("]");
    }

    protected void endObject() {
        this.endNewLine();
        this.writer.write("}");
    }

    private void startNewLine() {
        if (++this.depth > 0) {
            this.newLineProposed = true;
        }
    }

    private void endNewLine() {
        if (this.depth-- > 0) {
            if ((this.format.mode() & Format.COMPACT_EMPTY_ELEMENT) != 0 && this.newLineProposed) {
                this.newLineProposed = false;
            } else {
                this.writeNewLine();
            }
        }
    }

    private void writeNewLine() {
        int n2 = this.depth;
        this.writer.write(this.format.getNewLine());
        while (n2-- > 0) {
            this.writer.write(this.format.getLineIndenter());
        }
        this.newLineProposed = false;
    }

    private void writeText(String string) {
        int n2 = string.length();
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block9;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block9;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block9;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block9;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block9;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block9;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block9;
                }
                default: {
                    if (c2 > '\u001f') {
                        this.writer.write(c2);
                        continue block9;
                    }
                    this.writer.write("\\u");
                    String string2 = "000" + Integer.toHexString(c2);
                    this.writer.write(string2.substring(string2.length() - 4));
                }
            }
        }
    }

    public static class Format {
        public static int SPACE_AFTER_LABEL = 1;
        public static int COMPACT_EMPTY_ELEMENT = 2;
        private char[] lineIndenter;
        private char[] newLine;
        private final int mode;
        private final NameCoder nameCoder;

        public Format() {
            this(new char[]{' ', ' '}, new char[]{'\n'}, SPACE_AFTER_LABEL | COMPACT_EMPTY_ELEMENT);
        }

        public Format(char[] cArray, char[] cArray2, int n2) {
            this(cArray, cArray2, n2, new NoNameCoder());
        }

        public Format(char[] cArray, char[] cArray2, int n2, NameCoder nameCoder) {
            this.lineIndenter = cArray;
            this.newLine = cArray2;
            this.mode = n2;
            this.nameCoder = nameCoder;
        }

        public char[] getLineIndenter() {
            return this.lineIndenter;
        }

        public char[] getNewLine() {
            return this.newLine;
        }

        public int mode() {
            return this.mode;
        }

        public NameCoder getNameCoder() {
            return this.nameCoder;
        }
    }
}

