/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.path;

import java.util.ArrayList;
import zz.com.thoughtworks.xstream.core.util.FastStack;

public class Path {
    private final String[] chunks;
    private transient String pathAsString;
    private transient String pathExplicit;
    private static final Path DOT = new Path(new String[]{"."});

    public Path(String string) {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        this.pathAsString = string;
        while ((n2 = string.indexOf(47, n3)) != -1) {
            arrayList.add(this.normalize(string, n3, n2));
            n3 = n2 + 1;
        }
        arrayList.add(this.normalize(string, n3, string.length()));
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.chunks = stringArray;
    }

    private String normalize(String string, int n2, int n3) {
        if (n3 - n2 > 3 && string.charAt(n3 - 3) == '[' && string.charAt(n3 - 2) == '1' && string.charAt(n3 - 1) == ']') {
            this.pathAsString = null;
            return string.substring(n2, n3 - 3);
        }
        return string.substring(n2, n3);
    }

    public Path(String[] stringArray) {
        this.chunks = stringArray;
    }

    public String toString() {
        if (this.pathAsString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.chunks.length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(this.chunks[i2]);
            }
            this.pathAsString = stringBuffer.toString();
        }
        return this.pathAsString;
    }

    public String explicit() {
        if (this.pathExplicit == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.chunks.length; ++i2) {
                char c2;
                if (i2 > 0) {
                    stringBuffer.append('/');
                }
                String string = this.chunks[i2];
                stringBuffer.append(string);
                int n2 = string.length();
                if (n2 <= 0 || (c2 = string.charAt(n2 - 1)) == ']' || c2 == '.') continue;
                stringBuffer.append("[1]");
            }
            this.pathExplicit = stringBuffer.toString();
        }
        return this.pathExplicit;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Path)) {
            return false;
        }
        Path path = (Path)object;
        if (this.chunks.length != path.chunks.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            if (this.chunks[i2].equals(path.chunks[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 543645643;
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            n2 = 29 * n2 + this.chunks[i2].hashCode();
        }
        return n2;
    }

    public Path relativeTo(Path path) {
        int n2;
        int n3 = this.depthOfPathDivergence(this.chunks, path.chunks);
        String[] stringArray = new String[this.chunks.length + path.chunks.length - 2 * n3];
        int n4 = 0;
        for (n2 = n3; n2 < this.chunks.length; ++n2) {
            stringArray[n4++] = "..";
        }
        for (n2 = n3; n2 < path.chunks.length; ++n2) {
            stringArray[n4++] = path.chunks[n2];
        }
        if (n4 == 0) {
            return DOT;
        }
        return new Path(stringArray);
    }

    private int depthOfPathDivergence(String[] stringArray, String[] stringArray2) {
        int n2 = Math.min(stringArray.length, stringArray2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2].equals(stringArray2[i2])) continue;
            return i2;
        }
        return n2;
    }

    public Path apply(Path path) {
        int n2;
        FastStack fastStack = new FastStack(16);
        for (n2 = 0; n2 < this.chunks.length; ++n2) {
            fastStack.push(this.chunks[n2]);
        }
        for (n2 = 0; n2 < path.chunks.length; ++n2) {
            String string = path.chunks[n2];
            if (string.equals("..")) {
                fastStack.pop();
                continue;
            }
            if (string.equals(".")) continue;
            fastStack.push(string);
        }
        String[] stringArray = new String[fastStack.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)fastStack.get(i2);
        }
        return new Path(stringArray);
    }

    public boolean isAncestor(Path path) {
        if (path == null || path.chunks.length < this.chunks.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            if (this.chunks[i2].equals(path.chunks[i2])) continue;
            return false;
        }
        return true;
    }
}

