/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.path;

import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.io.path.Path;

public class PathTracker {
    private int pointer;
    private int capacity;
    private String[] pathStack;
    private Map[] indexMapStack;
    private Path currentPath;

    public PathTracker() {
        this(16);
    }

    public PathTracker(int n2) {
        this.capacity = Math.max(1, n2);
        this.pathStack = new String[this.capacity];
        this.indexMapStack = new Map[this.capacity];
    }

    public void pushElement(String string) {
        if (this.pointer + 1 >= this.capacity) {
            this.resizeStacks(this.capacity * 2);
        }
        this.pathStack[this.pointer] = string;
        HashMap<String, Integer> hashMap = this.indexMapStack[this.pointer];
        if (hashMap == null) {
            this.indexMapStack[this.pointer] = hashMap = new HashMap<String, Integer>();
        }
        if (hashMap.containsKey(string)) {
            hashMap.put(string, new Integer((Integer)hashMap.get(string) + 1));
        } else {
            hashMap.put(string, new Integer(1));
        }
        ++this.pointer;
        this.currentPath = null;
    }

    public void popElement() {
        this.indexMapStack[this.pointer] = null;
        this.pathStack[this.pointer] = null;
        this.currentPath = null;
        --this.pointer;
    }

    public String peekElement() {
        return this.peekElement(0);
    }

    public String peekElement(int n2) {
        String string;
        if (n2 < -this.pointer || n2 > 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = this.pointer + n2 - 1;
        Integer n4 = (Integer)this.indexMapStack[n3].get(this.pathStack[n3]);
        int n5 = n4;
        if (n5 > 1) {
            StringBuffer stringBuffer = new StringBuffer(this.pathStack[n3].length() + 6);
            stringBuffer.append(this.pathStack[n3]).append('[').append(n5).append(']');
            string = stringBuffer.toString();
        } else {
            string = this.pathStack[n3];
        }
        return string;
    }

    public int depth() {
        return this.pointer;
    }

    private void resizeStacks(int n2) {
        String[] stringArray = new String[n2];
        Map[] mapArray = new Map[n2];
        int n3 = Math.min(this.capacity, n2);
        System.arraycopy(this.pathStack, 0, stringArray, 0, n3);
        System.arraycopy(this.indexMapStack, 0, mapArray, 0, n3);
        this.pathStack = stringArray;
        this.indexMapStack = mapArray;
        this.capacity = n2;
    }

    public Path getPath() {
        if (this.currentPath == null) {
            String[] stringArray = new String[this.pointer + 1];
            stringArray[0] = "";
            int n2 = -this.pointer;
            while (++n2 <= 0) {
                String string;
                stringArray[n2 + this.pointer] = string = this.peekElement(n2);
            }
            this.currentPath = new Path(stringArray);
        }
        return this.currentPath;
    }
}

