/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import zz.com.thoughtworks.xstream.core.util.XmlHeaderAwareReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import zz.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import zz.com.thoughtworks.xstream.io.xml.XppReader;
import zz.org.xmlpull.v1.XmlPullParser;
import zz.org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractXppDriver
extends AbstractXmlDriver {
    public AbstractXppDriver(NameCoder nameCoder) {
        super(nameCoder);
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            return new XppReader(reader, this.createParser(), this.getNameCoder());
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new StreamException("Cannot create XmlPullParser", xmlPullParserException);
        }
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        try {
            return this.createReader(new XmlHeaderAwareReader(inputStream));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new StreamException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        return new PrettyPrintWriter(writer, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        return this.createWriter(new OutputStreamWriter(outputStream));
    }

    protected abstract XmlPullParser createParser() throws XmlPullParserException;
}

