/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.File;
import java.io.FilterWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.xml.sax.SAXException;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import zz.com.thoughtworks.xstream.io.xml.Dom4JReader;
import zz.com.thoughtworks.xstream.io.xml.Dom4JXmlWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import zz.org.dom4j.Document;
import zz.org.dom4j.DocumentException;
import zz.org.dom4j.DocumentFactory;
import zz.org.dom4j.io.OutputFormat;
import zz.org.dom4j.io.SAXReader;
import zz.org.dom4j.io.XMLWriter;

public class Dom4JDriver
extends AbstractXmlDriver {
    private DocumentFactory documentFactory;
    private OutputFormat outputFormat;

    public Dom4JDriver() {
        this(new XmlFriendlyNameCoder());
    }

    public Dom4JDriver(NameCoder nameCoder) {
        this(new DocumentFactory(), OutputFormat.createPrettyPrint(), nameCoder);
        this.outputFormat.setTrimText(false);
    }

    public Dom4JDriver(DocumentFactory documentFactory, OutputFormat outputFormat) {
        this(documentFactory, outputFormat, new XmlFriendlyNameCoder());
    }

    public Dom4JDriver(DocumentFactory documentFactory, OutputFormat outputFormat, NameCoder nameCoder) {
        super(nameCoder);
        this.documentFactory = documentFactory;
        this.outputFormat = outputFormat;
    }

    public Dom4JDriver(DocumentFactory documentFactory, OutputFormat outputFormat, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(documentFactory, outputFormat, (NameCoder)xmlFriendlyReplacer);
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            Document document = this.createReader().read(reader);
            return new Dom4JReader(document, this.getNameCoder());
        }
        catch (DocumentException documentException) {
            throw new StreamException(documentException);
        }
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        try {
            Document document = this.createReader().read(inputStream);
            return new Dom4JReader(document, this.getNameCoder());
        }
        catch (DocumentException documentException) {
            throw new StreamException(documentException);
        }
    }

    public HierarchicalStreamReader createReader(URL uRL) {
        try {
            Document document = this.createReader().read(uRL);
            return new Dom4JReader(document, this.getNameCoder());
        }
        catch (DocumentException documentException) {
            throw new StreamException(documentException);
        }
    }

    public HierarchicalStreamReader createReader(File file) {
        try {
            Document document = this.createReader().read(file);
            return new Dom4JReader(document, this.getNameCoder());
        }
        catch (DocumentException documentException) {
            throw new StreamException(documentException);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        final HierarchicalStreamWriter[] hierarchicalStreamWriterArray = new HierarchicalStreamWriter[1];
        FilterWriter filterWriter = new FilterWriter(writer){

            public void close() {
                hierarchicalStreamWriterArray[0].close();
            }
        };
        hierarchicalStreamWriterArray[0] = new Dom4JXmlWriter(new XMLWriter((Writer)filterWriter, this.outputFormat), this.getNameCoder());
        return hierarchicalStreamWriterArray[0];
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        return this.createWriter(outputStreamWriter);
    }

    protected SAXReader createReader() throws DocumentException {
        SAXReader sAXReader = new SAXReader();
        try {
            sAXReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (SAXException sAXException) {
            throw new DocumentException("Cannot disable DOCTYPE processing", (Throwable)sAXException);
        }
        return sAXReader;
    }
}

