/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import zz.com.thoughtworks.xstream.core.util.FastStack;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import zz.org.dom4j.Element;
import zz.org.dom4j.io.XMLWriter;
import zz.org.dom4j.tree.DefaultElement;

public class Dom4JXmlWriter
extends AbstractXmlWriter {
    private final XMLWriter writer;
    private final FastStack elementStack;
    private AttributesImpl attributes;
    private boolean started;
    private boolean children;

    public Dom4JXmlWriter(XMLWriter xMLWriter) {
        this(xMLWriter, new XmlFriendlyNameCoder());
    }

    public Dom4JXmlWriter(XMLWriter xMLWriter, NameCoder nameCoder) {
        super(nameCoder);
        this.writer = xMLWriter;
        this.elementStack = new FastStack(16);
        this.attributes = new AttributesImpl();
        try {
            xMLWriter.startDocument();
        }
        catch (SAXException sAXException) {
            throw new StreamException(sAXException);
        }
    }

    public Dom4JXmlWriter(XMLWriter xMLWriter, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(xMLWriter, (NameCoder)xmlFriendlyReplacer);
    }

    public void startNode(String string) {
        if (this.elementStack.size() > 0) {
            try {
                this.startElement();
            }
            catch (SAXException sAXException) {
                throw new StreamException(sAXException);
            }
            this.started = false;
        }
        this.elementStack.push(this.encodeNode(string));
        this.children = false;
    }

    public void setValue(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length > 0) {
            try {
                this.startElement();
                this.writer.characters(cArray, 0, cArray.length);
            }
            catch (SAXException sAXException) {
                throw new StreamException(sAXException);
            }
            this.children = true;
        }
    }

    public void addAttribute(String string, String string2) {
        this.attributes.addAttribute("", "", this.encodeAttribute(string), "string", string2);
    }

    public void endNode() {
        try {
            if (!this.children) {
                DefaultElement defaultElement = new DefaultElement((String)this.elementStack.pop());
                for (int i2 = 0; i2 < this.attributes.getLength(); ++i2) {
                    defaultElement.addAttribute(this.attributes.getQName(i2), this.attributes.getValue(i2));
                }
                this.writer.write((Element)defaultElement);
                this.attributes.clear();
                this.children = true;
                this.started = true;
            } else {
                this.startElement();
                this.writer.endElement("", "", (String)this.elementStack.pop());
            }
        }
        catch (SAXException sAXException) {
            throw new StreamException(sAXException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void close() {
        try {
            this.writer.endDocument();
            this.writer.flush();
        }
        catch (SAXException sAXException) {
            throw new StreamException(sAXException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    private void startElement() throws SAXException {
        if (!this.started) {
            this.writer.startElement("", "", (String)this.elementStack.peek(), (Attributes)this.attributes);
            this.attributes.clear();
            this.started = true;
        }
    }
}

