/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import zz.com.thoughtworks.xstream.io.xml.DomReader;
import zz.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class DomDriver
extends AbstractXmlDriver {
    private final String encoding;
    private DocumentBuilderFactory documentBuilderFactory;

    public DomDriver() {
        this((String)null);
    }

    public DomDriver(String string) {
        this(string, new XmlFriendlyNameCoder());
    }

    public DomDriver(String string, NameCoder nameCoder) {
        super(nameCoder);
        this.encoding = string;
    }

    public DomDriver(String string, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(string, (NameCoder)xmlFriendlyReplacer);
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        return this.createReader(new InputSource(reader));
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        return this.createReader(new InputSource(inputStream));
    }

    public HierarchicalStreamReader createReader(URL uRL) {
        return this.createReader(new InputSource(uRL.toExternalForm()));
    }

    public HierarchicalStreamReader createReader(File file) {
        return this.createReader(new InputSource(file.toURI().toASCIIString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HierarchicalStreamReader createReader(InputSource inputSource) {
        try {
            Object object;
            if (this.documentBuilderFactory == null) {
                object = this;
                synchronized (object) {
                    if (this.documentBuilderFactory == null) {
                        this.documentBuilderFactory = this.createDocumentBuilderFactory();
                    }
                }
            }
            object = this.documentBuilderFactory.newDocumentBuilder();
            if (this.encoding != null) {
                inputSource.setEncoding(this.encoding);
            }
            Document document = ((DocumentBuilder)object).parse(inputSource);
            return new DomReader(document, this.getNameCoder());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new StreamException(factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new StreamException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new StreamException(sAXException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        return new PrettyPrintWriter(writer, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        try {
            return this.createWriter(this.encoding != null ? new OutputStreamWriter(outputStream, this.encoding) : new OutputStreamWriter(outputStream));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new StreamException(unsupportedEncodingException);
        }
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        block5: {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            if (JVM.is15()) {
                try {
                    Method method = DocumentBuilderFactory.class.getMethod("setFeature", String.class, Boolean.TYPE);
                    method.invoke((Object)documentBuilderFactory, "http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ObjectAccessException("Cannot set feature of DocumentBuilderFactory.", illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (!JVM.is16() && (!(throwable instanceof ParserConfigurationException) || throwable.getMessage().indexOf("disallow-doctype-decl") >= 0)) break block5;
                    throw new StreamException(throwable);
                }
            }
        }
        documentBuilderFactory.setExpandEntityReferences(false);
        return documentBuilderFactory;
    }
}

