/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractDocumentReader;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class DomReader
extends AbstractDocumentReader {
    private Element currentElement;
    private StringBuffer textBuffer = new StringBuffer();
    private List childElements;

    public DomReader(Element element) {
        this(element, (NameCoder)new XmlFriendlyNameCoder());
    }

    public DomReader(Document document) {
        this(document.getDocumentElement());
    }

    public DomReader(Element element, NameCoder nameCoder) {
        super((Object)element, nameCoder);
    }

    public DomReader(Document document, NameCoder nameCoder) {
        this(document.getDocumentElement(), nameCoder);
    }

    public DomReader(Element element, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(element, (NameCoder)xmlFriendlyReplacer);
    }

    public DomReader(Document document, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(document.getDocumentElement(), (NameCoder)xmlFriendlyReplacer);
    }

    public String getNodeName() {
        return this.decodeNode(this.currentElement.getTagName());
    }

    public String getValue() {
        NodeList nodeList = this.currentElement.getChildNodes();
        this.textBuffer.setLength(0);
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            if (!(node instanceof Text)) continue;
            Text text = (Text)node;
            this.textBuffer.append(text.getData());
        }
        return this.textBuffer.toString();
    }

    public String getAttribute(String string) {
        Attr attr = this.currentElement.getAttributeNode(this.encodeAttribute(string));
        return attr == null ? null : attr.getValue();
    }

    public String getAttribute(int n2) {
        return ((Attr)this.currentElement.getAttributes().item(n2)).getValue();
    }

    public int getAttributeCount() {
        return this.currentElement.getAttributes().getLength();
    }

    public String getAttributeName(int n2) {
        return this.decodeAttribute(((Attr)this.currentElement.getAttributes().item(n2)).getName());
    }

    protected Object getParent() {
        return this.currentElement.getParentNode();
    }

    protected Object getChild(int n2) {
        return this.childElements.get(n2);
    }

    protected int getChildCount() {
        return this.childElements.size();
    }

    protected void reassignCurrentElement(Object object) {
        this.currentElement = (Element)object;
        NodeList nodeList = this.currentElement.getChildNodes();
        this.childElements = new ArrayList();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (!(node instanceof Element)) continue;
            this.childElements.add(node);
        }
    }

    public String peekNextChild() {
        NodeList nodeList = this.currentElement.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (!(node instanceof Element)) continue;
            return this.decodeNode(((Element)node).getTagName());
        }
        return null;
    }
}

