/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractDocumentWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class DomWriter
extends AbstractDocumentWriter {
    private final Document document;
    private boolean hasRootElement;

    public DomWriter(Document document) {
        this(document, (NameCoder)new XmlFriendlyNameCoder());
    }

    public DomWriter(Element element) {
        this(element, (NameCoder)new XmlFriendlyNameCoder());
    }

    public DomWriter(Document document, NameCoder nameCoder) {
        this(document.getDocumentElement(), document, nameCoder);
    }

    public DomWriter(Element element, Document document, NameCoder nameCoder) {
        super((Object)element, nameCoder);
        this.document = document;
        this.hasRootElement = document.getDocumentElement() != null;
    }

    public DomWriter(Element element, NameCoder nameCoder) {
        this(element, element.getOwnerDocument(), nameCoder);
    }

    public DomWriter(Document document, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(document.getDocumentElement(), document, (NameCoder)xmlFriendlyReplacer);
    }

    public DomWriter(Element element, Document document, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(element, document, (NameCoder)xmlFriendlyReplacer);
    }

    public DomWriter(Element element, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(element, element.getOwnerDocument(), (NameCoder)xmlFriendlyReplacer);
    }

    protected Object createNode(String string) {
        Element element = this.document.createElement(this.encodeNode(string));
        Element element2 = this.top();
        if (element2 != null) {
            this.top().appendChild(element);
        } else if (!this.hasRootElement) {
            this.document.appendChild(element);
            this.hasRootElement = true;
        }
        return element;
    }

    public void addAttribute(String string, String string2) {
        this.top().setAttribute(this.encodeAttribute(string), string2);
    }

    public void setValue(String string) {
        this.top().appendChild(this.document.createTextNode(string));
    }

    private Element top() {
        return (Element)this.getCurrent();
    }
}

