/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import zz.com.thoughtworks.xstream.io.AbstractDriver;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.JDom2Reader;
import zz.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.org.jdom2.Document;
import zz.org.jdom2.JDOMException;
import zz.org.jdom2.input.SAXBuilder;

public class JDom2Driver
extends AbstractDriver {
    public JDom2Driver() {
        super(new XmlFriendlyNameCoder());
    }

    public JDom2Driver(NameCoder nameCoder) {
        super(nameCoder);
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            SAXBuilder sAXBuilder = this.createBuilder();
            Document document = sAXBuilder.build(reader);
            return new JDom2Reader(document, this.getNameCoder());
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        catch (JDOMException jDOMException) {
            throw new StreamException(jDOMException);
        }
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        try {
            SAXBuilder sAXBuilder = this.createBuilder();
            Document document = sAXBuilder.build(inputStream);
            return new JDom2Reader(document, this.getNameCoder());
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        catch (JDOMException jDOMException) {
            throw new StreamException(jDOMException);
        }
    }

    public HierarchicalStreamReader createReader(URL uRL) {
        try {
            SAXBuilder sAXBuilder = this.createBuilder();
            Document document = sAXBuilder.build(uRL);
            return new JDom2Reader(document, this.getNameCoder());
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        catch (JDOMException jDOMException) {
            throw new StreamException(jDOMException);
        }
    }

    public HierarchicalStreamReader createReader(File file) {
        try {
            SAXBuilder sAXBuilder = this.createBuilder();
            Document document = sAXBuilder.build(file);
            return new JDom2Reader(document, this.getNameCoder());
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        catch (JDOMException jDOMException) {
            throw new StreamException(jDOMException);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        return new PrettyPrintWriter(writer, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        return new PrettyPrintWriter(new OutputStreamWriter(outputStream));
    }

    protected SAXBuilder createBuilder() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return sAXBuilder;
    }
}

