/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import zz.com.thoughtworks.xstream.io.xml.JDomReader;
import zz.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import zz.org.jdom.Document;
import zz.org.jdom.JDOMException;
import zz.org.jdom.input.SAXBuilder;

public class JDomDriver
extends AbstractXmlDriver {
    public JDomDriver() {
        super(new XmlFriendlyNameCoder());
    }

    public JDomDriver(NameCoder nameCoder) {
        super(nameCoder);
    }

    public JDomDriver(XmlFriendlyReplacer xmlFriendlyReplacer) {
        this((NameCoder)xmlFriendlyReplacer);
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            SAXBuilder sAXBuilder = this.createBuilder();
            Document document = sAXBuilder.build(reader);
            return new JDomReader(document, this.getNameCoder());
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        catch (JDOMException jDOMException) {
            throw new StreamException(jDOMException);
        }
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        try {
            SAXBuilder sAXBuilder = this.createBuilder();
            Document document = sAXBuilder.build(inputStream);
            return new JDomReader(document, this.getNameCoder());
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        catch (JDOMException jDOMException) {
            throw new StreamException(jDOMException);
        }
    }

    public HierarchicalStreamReader createReader(URL uRL) {
        try {
            SAXBuilder sAXBuilder = this.createBuilder();
            Document document = sAXBuilder.build(uRL);
            return new JDomReader(document, this.getNameCoder());
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        catch (JDOMException jDOMException) {
            throw new StreamException(jDOMException);
        }
    }

    public HierarchicalStreamReader createReader(File file) {
        try {
            SAXBuilder sAXBuilder = this.createBuilder();
            Document document = sAXBuilder.build(file);
            return new JDomReader(document, this.getNameCoder());
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
        catch (JDOMException jDOMException) {
            throw new StreamException(jDOMException);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        return new PrettyPrintWriter(writer, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        return new PrettyPrintWriter(new OutputStreamWriter(outputStream));
    }

    protected SAXBuilder createBuilder() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return sAXBuilder;
    }
}

