/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.Writer;
import zz.com.thoughtworks.xstream.core.util.FastStack;
import zz.com.thoughtworks.xstream.core.util.QuickWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class PrettyPrintWriter
extends AbstractXmlWriter {
    public static int XML_QUIRKS = -1;
    public static int XML_1_0 = 0;
    public static int XML_1_1 = 1;
    private final QuickWriter writer;
    private final FastStack elementStack = new FastStack(16);
    private final char[] lineIndenter;
    private final int mode;
    private boolean tagInProgress;
    protected int depth;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;
    private String newLine;
    private static final char[] NULL = "&#x0;".toCharArray();
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();
    private static final char[] CR = "&#xd;".toCharArray();
    private static final char[] QUOT = "&quot;".toCharArray();
    private static final char[] APOS = "&apos;".toCharArray();
    private static final char[] CLOSE = "</".toCharArray();

    private PrettyPrintWriter(Writer writer, int n2, char[] cArray, NameCoder nameCoder, String string) {
        super(nameCoder);
        this.writer = new QuickWriter(writer);
        this.lineIndenter = cArray;
        this.newLine = string;
        this.mode = n2;
        if (n2 < XML_QUIRKS || n2 > XML_1_1) {
            throw new IllegalArgumentException("Not a valid XML mode");
        }
    }

    public PrettyPrintWriter(Writer writer, char[] cArray, String string, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(writer, XML_QUIRKS, cArray, xmlFriendlyReplacer, string);
    }

    public PrettyPrintWriter(Writer writer, int n2, char[] cArray, NameCoder nameCoder) {
        this(writer, n2, cArray, nameCoder, "\n");
    }

    public PrettyPrintWriter(Writer writer, int n2, char[] cArray, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(writer, n2, cArray, xmlFriendlyReplacer, "\n");
    }

    public PrettyPrintWriter(Writer writer, char[] cArray, String string) {
        this(writer, cArray, string, new XmlFriendlyReplacer());
    }

    public PrettyPrintWriter(Writer writer, int n2, char[] cArray) {
        this(writer, n2, cArray, new XmlFriendlyNameCoder());
    }

    public PrettyPrintWriter(Writer writer, char[] cArray) {
        this(writer, XML_QUIRKS, cArray);
    }

    public PrettyPrintWriter(Writer writer, String string, String string2) {
        this(writer, string.toCharArray(), string2);
    }

    public PrettyPrintWriter(Writer writer, int n2, String string) {
        this(writer, n2, string.toCharArray());
    }

    public PrettyPrintWriter(Writer writer, String string) {
        this(writer, string.toCharArray());
    }

    public PrettyPrintWriter(Writer writer, int n2, NameCoder nameCoder) {
        this(writer, n2, new char[]{' ', ' '}, nameCoder);
    }

    public PrettyPrintWriter(Writer writer, int n2, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(writer, n2, new char[]{' ', ' '}, xmlFriendlyReplacer);
    }

    public PrettyPrintWriter(Writer writer, NameCoder nameCoder) {
        this(writer, XML_QUIRKS, new char[]{' ', ' '}, nameCoder, "\n");
    }

    public PrettyPrintWriter(Writer writer, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(writer, new char[]{' ', ' '}, "\n", xmlFriendlyReplacer);
    }

    public PrettyPrintWriter(Writer writer, int n2) {
        this(writer, n2, new char[]{' ', ' '});
    }

    public PrettyPrintWriter(Writer writer) {
        this(writer, new char[]{' ', ' '});
    }

    public void startNode(String string) {
        String string2 = this.encodeNode(string);
        this.tagIsEmpty = false;
        this.finishTag();
        this.writer.write('<');
        this.writer.write(string2);
        this.elementStack.push(string2);
        this.tagInProgress = true;
        ++this.depth;
        this.readyForNewLine = true;
        this.tagIsEmpty = true;
    }

    public void startNode(String string, Class clazz) {
        this.startNode(string);
    }

    public void setValue(String string) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        this.writeText(this.writer, string);
    }

    public void addAttribute(String string, String string2) {
        this.writer.write(' ');
        this.writer.write(this.encodeAttribute(string));
        this.writer.write('=');
        this.writer.write('\"');
        this.writeAttributeValue(this.writer, string2);
        this.writer.write('\"');
    }

    protected void writeAttributeValue(QuickWriter quickWriter, String string) {
        this.writeText(string, true);
    }

    protected void writeText(QuickWriter quickWriter, String string) {
        this.writeText(string, false);
    }

    private void writeText(String string, boolean bl2) {
        int n2 = string.length();
        block10: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\u0000': {
                    if (this.mode == XML_QUIRKS) {
                        this.writer.write(NULL);
                        continue block10;
                    }
                    throw new StreamException("Invalid character 0x0 in XML stream");
                }
                case '&': {
                    this.writer.write(AMP);
                    continue block10;
                }
                case '<': {
                    this.writer.write(LT);
                    continue block10;
                }
                case '>': {
                    this.writer.write(GT);
                    continue block10;
                }
                case '\"': {
                    this.writer.write(QUOT);
                    continue block10;
                }
                case '\'': {
                    this.writer.write(APOS);
                    continue block10;
                }
                case '\r': {
                    this.writer.write(CR);
                    continue block10;
                }
                case '\t': 
                case '\n': {
                    if (!bl2) {
                        this.writer.write(c2);
                        continue block10;
                    }
                }
                default: {
                    if (Character.isDefined(c2) && !Character.isISOControl(c2)) {
                        if (this.mode != XML_QUIRKS && c2 > '\ud7ff' && c2 < '\ue000') {
                            throw new StreamException("Invalid character 0x" + Integer.toHexString(c2) + " in XML stream");
                        }
                        this.writer.write(c2);
                        continue block10;
                    }
                    if (this.mode == XML_1_0 && (c2 < '\t' || c2 == '\u000b' || c2 == '\f' || c2 == '\u000e' || c2 >= '\u000f' && c2 <= '\u001f')) {
                        throw new StreamException("Invalid character 0x" + Integer.toHexString(c2) + " in XML 1.0 stream");
                    }
                    if (this.mode != XML_QUIRKS && (c2 == '\ufffe' || c2 == '\uffff')) {
                        throw new StreamException("Invalid character 0x" + Integer.toHexString(c2) + " in XML stream");
                    }
                    this.writer.write("&#x");
                    this.writer.write(Integer.toHexString(c2));
                    this.writer.write(';');
                }
            }
        }
    }

    public void endNode() {
        --this.depth;
        if (this.tagIsEmpty) {
            this.writer.write('/');
            this.readyForNewLine = false;
            this.finishTag();
            this.elementStack.popSilently();
        } else {
            this.finishTag();
            this.writer.write(CLOSE);
            this.writer.write((String)this.elementStack.pop());
            this.writer.write('>');
        }
        this.readyForNewLine = true;
        if (this.depth == 0) {
            this.writer.flush();
        }
    }

    private void finishTag() {
        if (this.tagInProgress) {
            this.writer.write('>');
        }
        this.tagInProgress = false;
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    protected void endOfLine() {
        this.writer.write(this.getNewLine());
        for (int i2 = 0; i2 < this.depth; ++i2) {
            this.writer.write(this.lineIndenter);
        }
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }

    protected String getNewLine() {
        return this.newLine;
    }
}

