/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import zz.com.thoughtworks.xstream.XStream;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public final class SaxWriter
extends AbstractXmlWriter
implements XMLReader {
    public static final String CONFIGURED_XSTREAM_PROPERTY = "http://com.thoughtworks.xstream/sax/property/configured-xstream";
    public static final String SOURCE_OBJECT_LIST_PROPERTY = "http://com.thoughtworks.xstream/sax/property/source-object-list";
    private EntityResolver entityResolver = null;
    private DTDHandler dtdHandler = null;
    private ContentHandler contentHandler = null;
    private ErrorHandler errorHandler = null;
    private Map features = new HashMap();
    private final Map properties = new HashMap();
    private final boolean includeEnclosingDocument;
    private int depth = 0;
    private List elementStack = new LinkedList();
    private char[] buffer = new char[128];
    private boolean startTagInProgress = false;
    private final AttributesImpl attributeList = new AttributesImpl();

    public SaxWriter(NameCoder nameCoder) {
        this(true, nameCoder);
    }

    public SaxWriter(boolean bl2, NameCoder nameCoder) {
        super(nameCoder);
        this.includeEnclosingDocument = bl2;
    }

    public SaxWriter(XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(true, xmlFriendlyReplacer);
    }

    public SaxWriter(boolean bl2, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(bl2, (NameCoder)xmlFriendlyReplacer);
    }

    public SaxWriter(boolean bl2) {
        this(bl2, new XmlFriendlyNameCoder());
    }

    public SaxWriter() {
        this(true);
    }

    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException {
        if (!string.equals("http://xml.org/sax/features/namespaces") && !string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            throw new SAXNotRecognizedException(string);
        }
        this.features.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/features/namespaces") || string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            Boolean bl2 = (Boolean)this.features.get(string);
            if (bl2 == null) {
                bl2 = Boolean.FALSE;
            }
            return bl2;
        }
        throw new SAXNotRecognizedException(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object list) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(CONFIGURED_XSTREAM_PROPERTY)) {
            if (!(list instanceof XStream)) {
                throw new SAXNotSupportedException("Value for property \"http://com.thoughtworks.xstream/sax/property/configured-xstream\" must be a non-null XStream object");
            }
        } else {
            if (!string.equals(SOURCE_OBJECT_LIST_PROPERTY)) throw new SAXNotRecognizedException(string);
            if (!(list instanceof List)) throw new SAXNotSupportedException("Value for property \"http://com.thoughtworks.xstream/sax/property/source-object-list\" must be a non-null List object");
            List list2 = list;
            if (list2.isEmpty()) {
                throw new SAXNotSupportedException("Value for property \"http://com.thoughtworks.xstream/sax/property/source-object-list\" shall not be an empty list");
            }
            list = Collections.unmodifiableList(new ArrayList(list2));
        }
        this.properties.put(string, list);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if (string.equals(CONFIGURED_XSTREAM_PROPERTY) || string.equals(SOURCE_OBJECT_LIST_PROPERTY)) {
            return this.properties.get(string);
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            throw new NullPointerException("resolver");
        }
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            throw new NullPointerException("handler");
        }
        this.dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("handler");
        }
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException("handler");
        }
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(String string) throws SAXException {
        this.parse();
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        List list;
        XStream xStream = (XStream)this.properties.get(CONFIGURED_XSTREAM_PROPERTY);
        if (xStream == null) {
            xStream = new XStream();
        }
        if ((list = (List)this.properties.get(SOURCE_OBJECT_LIST_PROPERTY)) == null || list.isEmpty()) {
            throw new SAXException("Missing or empty source object list. Setting property \"http://com.thoughtworks.xstream/sax/property/source-object-list\" is mandatory");
        }
        try {
            this.startDocument(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                xStream.marshal(iterator.next(), this);
            }
            this.endDocument(true);
        }
        catch (StreamException streamException) {
            if (streamException.getCause() instanceof SAXException) {
                throw (SAXException)streamException.getCause();
            }
            throw new SAXException(streamException);
        }
    }

    public void startNode(String string) {
        try {
            if (this.depth != 0) {
                this.flushStartTag();
            } else if (this.includeEnclosingDocument) {
                this.startDocument(false);
            }
            this.elementStack.add(0, this.escapeXmlName(string));
            this.startTagInProgress = true;
            ++this.depth;
        }
        catch (SAXException sAXException) {
            throw new StreamException(sAXException);
        }
    }

    public void addAttribute(String string, String string2) {
        if (!this.startTagInProgress) {
            throw new StreamException(new IllegalStateException("No startElement being processed"));
        }
        String string3 = this.escapeXmlName(string);
        this.attributeList.addAttribute("", string3, string3, "CDATA", string2);
    }

    public void setValue(String string) {
        try {
            this.flushStartTag();
            int n2 = string.length();
            if (n2 > this.buffer.length) {
                this.buffer = new char[n2];
            }
            string.getChars(0, n2, this.buffer, 0);
            this.contentHandler.characters(this.buffer, 0, n2);
        }
        catch (SAXException sAXException) {
            throw new StreamException(sAXException);
        }
    }

    public void endNode() {
        try {
            this.flushStartTag();
            String string = (String)this.elementStack.remove(0);
            this.contentHandler.endElement("", string, string);
            --this.depth;
            if (this.depth == 0 && this.includeEnclosingDocument) {
                this.endDocument(false);
            }
        }
        catch (SAXException sAXException) {
            throw new StreamException(sAXException);
        }
    }

    private void startDocument(boolean bl2) throws SAXException {
        if (this.depth == 0) {
            this.contentHandler.startDocument();
            if (bl2) {
                ++this.depth;
            }
        }
    }

    private void endDocument(boolean bl2) throws SAXException {
        if (this.depth == 0 || this.depth == 1 && bl2) {
            this.contentHandler.endDocument();
            this.depth = 0;
        }
    }

    private void flushStartTag() throws SAXException {
        if (this.startTagInProgress) {
            String string = (String)this.elementStack.get(0);
            this.contentHandler.startElement("", string, string, this.attributeList);
            this.attributeList.clear();
            this.startTagInProgress = false;
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

