/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.ReaderWrapper;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractPullReader;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import zz.com.thoughtworks.xstream.io.xml.QNameMap;
import zz.com.thoughtworks.xstream.io.xml.StaxReader;
import zz.com.thoughtworks.xstream.io.xml.StaxWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class StaxDriver
extends AbstractXmlDriver {
    private QNameMap qnameMap;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;

    public StaxDriver() {
        this(new QNameMap());
    }

    public StaxDriver(QNameMap qNameMap) {
        this(qNameMap, new XmlFriendlyNameCoder());
    }

    public StaxDriver(QNameMap qNameMap, NameCoder nameCoder) {
        super(nameCoder);
        this.qnameMap = qNameMap;
    }

    public StaxDriver(NameCoder nameCoder) {
        this(new QNameMap(), nameCoder);
    }

    public StaxDriver(QNameMap qNameMap, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(qNameMap, (NameCoder)xmlFriendlyReplacer);
    }

    public StaxDriver(XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(new QNameMap(), (NameCoder)xmlFriendlyReplacer);
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            return this.createStaxReader(this.createParser(reader));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        try {
            return this.createStaxReader(this.createParser(inputStream));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public HierarchicalStreamReader createReader(URL uRL) {
        try {
            final InputStream inputStream = uRL.openStream();
            AbstractPullReader abstractPullReader = this.createStaxReader(this.createParser(new StreamSource(inputStream, uRL.toExternalForm())));
            return new ReaderWrapper(abstractPullReader){

                public void close() {
                    super.close();
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public HierarchicalStreamReader createReader(File file) {
        try {
            final FileInputStream fileInputStream = new FileInputStream(file);
            AbstractPullReader abstractPullReader = this.createStaxReader(this.createParser(new StreamSource(fileInputStream, file.toURI().toASCIIString())));
            return new ReaderWrapper(abstractPullReader){

                public void close() {
                    super.close();
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new StreamException(fileNotFoundException);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        try {
            return this.createStaxWriter(this.getOutputFactory().createXMLStreamWriter(writer));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        try {
            return this.createStaxWriter(this.getOutputFactory().createXMLStreamWriter(outputStream));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public AbstractPullReader createStaxReader(XMLStreamReader xMLStreamReader) {
        return new StaxReader(this.qnameMap, xMLStreamReader, this.getNameCoder());
    }

    public StaxWriter createStaxWriter(XMLStreamWriter xMLStreamWriter, boolean bl2) throws XMLStreamException {
        return new StaxWriter(this.qnameMap, xMLStreamWriter, bl2, this.isRepairingNamespace(), this.getNameCoder());
    }

    public StaxWriter createStaxWriter(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        return this.createStaxWriter(xMLStreamWriter, true);
    }

    public QNameMap getQnameMap() {
        return this.qnameMap;
    }

    public void setQnameMap(QNameMap qNameMap) {
        this.qnameMap = qNameMap;
    }

    public XMLInputFactory getInputFactory() {
        if (this.inputFactory == null) {
            this.inputFactory = this.createInputFactory();
        }
        return this.inputFactory;
    }

    public XMLOutputFactory getOutputFactory() {
        if (this.outputFactory == null) {
            this.outputFactory = this.createOutputFactory();
        }
        return this.outputFactory;
    }

    public boolean isRepairingNamespace() {
        return Boolean.TRUE.equals(this.getOutputFactory().getProperty("javax.xml.stream.isRepairingNamespaces"));
    }

    public void setRepairingNamespace(boolean bl2) {
        this.getOutputFactory().setProperty("javax.xml.stream.isRepairingNamespaces", bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected XMLStreamReader createParser(Reader reader) throws XMLStreamException {
        return this.getInputFactory().createXMLStreamReader(reader);
    }

    protected XMLStreamReader createParser(InputStream inputStream) throws XMLStreamException {
        return this.getInputFactory().createXMLStreamReader(inputStream);
    }

    protected XMLStreamReader createParser(Source source) throws XMLStreamException {
        return this.getInputFactory().createXMLStreamReader(source);
    }

    protected XMLInputFactory createInputFactory() {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        return xMLInputFactory;
    }

    protected XMLOutputFactory createOutputFactory() {
        return XMLOutputFactory.newInstance();
    }
}

