/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import zz.com.thoughtworks.xstream.converters.ErrorWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractPullReader;
import zz.com.thoughtworks.xstream.io.xml.QNameMap;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class StaxReader
extends AbstractPullReader {
    private final QNameMap qnameMap;
    private final XMLStreamReader in;

    public StaxReader(QNameMap qNameMap, XMLStreamReader xMLStreamReader) {
        this(qNameMap, xMLStreamReader, new XmlFriendlyNameCoder());
    }

    public StaxReader(QNameMap qNameMap, XMLStreamReader xMLStreamReader, NameCoder nameCoder) {
        super(nameCoder);
        this.qnameMap = qNameMap;
        this.in = xMLStreamReader;
        this.moveDown();
    }

    public StaxReader(QNameMap qNameMap, XMLStreamReader xMLStreamReader, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(qNameMap, xMLStreamReader, (NameCoder)xmlFriendlyReplacer);
    }

    protected int pullNextEvent() {
        try {
            switch (this.in.next()) {
                case 1: 
                case 7: {
                    return 1;
                }
                case 2: 
                case 8: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
            }
            return 0;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    protected String pullElementName() {
        QName qName = this.in.getName();
        return this.qnameMap.getJavaClassName(qName);
    }

    protected String pullText() {
        return this.in.getText();
    }

    public String getAttribute(String string) {
        return this.in.getAttributeValue(null, this.encodeAttribute(string));
    }

    public String getAttribute(int n2) {
        return this.in.getAttributeValue(n2);
    }

    public int getAttributeCount() {
        return this.in.getAttributeCount();
    }

    public String getAttributeName(int n2) {
        return this.decodeAttribute(this.in.getAttributeLocalName(n2));
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.in.getLocation().getLineNumber()));
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }
}

