/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import zz.com.thoughtworks.xstream.io.xml.QNameMap;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class StaxWriter
extends AbstractXmlWriter {
    private final QNameMap qnameMap;
    private final XMLStreamWriter out;
    private final boolean writeEnclosingDocument;
    private boolean namespaceRepairingMode;
    private int tagDepth;

    public StaxWriter(QNameMap qNameMap, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this(qNameMap, xMLStreamWriter, true, true);
    }

    public StaxWriter(QNameMap qNameMap, XMLStreamWriter xMLStreamWriter, NameCoder nameCoder) throws XMLStreamException {
        this(qNameMap, xMLStreamWriter, true, true, nameCoder);
    }

    public StaxWriter(QNameMap qNameMap, XMLStreamWriter xMLStreamWriter, boolean bl2, boolean bl3, NameCoder nameCoder) throws XMLStreamException {
        super(nameCoder);
        this.qnameMap = qNameMap;
        this.out = xMLStreamWriter;
        this.writeEnclosingDocument = bl2;
        this.namespaceRepairingMode = bl3;
        if (bl2) {
            xMLStreamWriter.writeStartDocument();
        }
    }

    public StaxWriter(QNameMap qNameMap, XMLStreamWriter xMLStreamWriter, boolean bl2, boolean bl3) throws XMLStreamException {
        this(qNameMap, xMLStreamWriter, bl2, bl3, new XmlFriendlyNameCoder());
    }

    public StaxWriter(QNameMap qNameMap, XMLStreamWriter xMLStreamWriter, boolean bl2, boolean bl3, XmlFriendlyReplacer xmlFriendlyReplacer) throws XMLStreamException {
        this(qNameMap, xMLStreamWriter, bl2, bl3, (NameCoder)xmlFriendlyReplacer);
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public void addAttribute(String string, String string2) {
        try {
            this.out.writeAttribute(this.encodeAttribute(string), string2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public void endNode() {
        try {
            --this.tagDepth;
            this.out.writeEndElement();
            if (this.tagDepth == 0 && this.writeEnclosingDocument) {
                this.out.writeEndDocument();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public void setValue(String string) {
        try {
            this.out.writeCharacters(string);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public void startNode(String string) {
        try {
            QName qName = this.qnameMap.getQName(this.encodeNode(string));
            String string2 = qName.getPrefix();
            String string3 = qName.getNamespaceURI();
            boolean bl2 = string2 != null && string2.length() > 0;
            boolean bl3 = string3 != null && string3.length() > 0;
            boolean bl4 = false;
            if (bl3) {
                if (bl2) {
                    String string4 = this.out.getNamespaceContext().getNamespaceURI(string2);
                    if (string4 == null || !string4.equals(string3)) {
                        bl4 = true;
                    }
                } else {
                    String string5 = this.out.getNamespaceContext().getNamespaceURI("");
                    if (string5 == null || !string5.equals(string3)) {
                        bl4 = true;
                    }
                }
            }
            this.out.writeStartElement(string2, qName.getLocalPart(), string3);
            if (bl2) {
                this.out.setPrefix(string2, string3);
            } else if (bl3 && bl4) {
                this.out.setDefaultNamespace(string3);
            }
            if (bl3 && bl4 && !this.isNamespaceRepairingMode()) {
                if (bl2) {
                    this.out.writeNamespace(string2, string3);
                } else {
                    this.out.writeDefaultNamespace(string3);
                }
            }
            ++this.tagDepth;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamException(xMLStreamException);
        }
    }

    public boolean isNamespaceRepairingMode() {
        return this.namespaceRepairingMode;
    }

    protected QNameMap getQNameMap() {
        return this.qnameMap;
    }

    protected XMLStreamWriter getXMLStreamWriter() {
        return this.out;
    }
}

