/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import zz.com.thoughtworks.xstream.XStream;
import zz.com.thoughtworks.xstream.io.xml.SaxWriter;

public class TraxSource
extends SAXSource {
    public static final String XSTREAM_FEATURE = "http://com.thoughtworks.xstream/XStreamSource/feature";
    private XMLReader xmlReader = null;
    private XStream xstream = null;
    private List source = null;

    public TraxSource() {
        super(new InputSource());
    }

    public TraxSource(Object object) {
        super(new InputSource());
        this.setSource(object);
    }

    public TraxSource(Object object, XStream xStream) {
        super(new InputSource());
        this.setSource(object);
        this.setXStream(xStream);
    }

    public TraxSource(List list) {
        super(new InputSource());
        this.setSourceAsList(list);
    }

    public TraxSource(List list, XStream xStream) {
        super(new InputSource());
        this.setSourceAsList(list);
        this.setXStream(xStream);
    }

    public void setInputSource(InputSource inputSource) {
        throw new UnsupportedOperationException();
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.createXMLReader(xMLReader);
    }

    public XMLReader getXMLReader() {
        if (this.xmlReader == null) {
            this.createXMLReader(null);
        }
        return this.xmlReader;
    }

    public void setXStream(XStream xStream) {
        if (xStream == null) {
            throw new IllegalArgumentException("xstream");
        }
        this.xstream = xStream;
        this.configureXMLReader();
    }

    public void setSource(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("obj");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        this.setSourceAsList(arrayList);
    }

    public void setSourceAsList(List list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("list");
        }
        this.source = list;
        this.configureXMLReader();
    }

    private void createXMLReader(XMLReader xMLReader) {
        if (xMLReader == null) {
            this.xmlReader = new SaxWriter();
        } else if (xMLReader instanceof XMLFilter) {
            XMLFilter xMLFilter = (XMLFilter)xMLReader;
            while (xMLFilter.getParent() instanceof XMLFilter) {
                xMLFilter = (XMLFilter)xMLFilter.getParent();
            }
            if (!(xMLFilter.getParent() instanceof SaxWriter)) {
                xMLFilter.setParent(new SaxWriter());
            }
            this.xmlReader = xMLReader;
        } else {
            throw new UnsupportedOperationException();
        }
        this.configureXMLReader();
    }

    private void configureXMLReader() {
        if (this.xmlReader != null) {
            try {
                if (this.xstream != null) {
                    this.xmlReader.setProperty("http://com.thoughtworks.xstream/sax/property/configured-xstream", this.xstream);
                }
                if (this.source != null) {
                    this.xmlReader.setProperty("http://com.thoughtworks.xstream/sax/property/source-object-list", this.source);
                }
            }
            catch (SAXException sAXException) {
                throw new IllegalArgumentException(sAXException.getMessage());
            }
        }
    }
}

