/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;

public class XmlFriendlyNameCoder
implements Cloneable,
NameCoder {
    private static final IntPair[] XML_NAME_START_CHAR_BOUNDS;
    private static final IntPair[] XML_NAME_CHAR_EXTRA_BOUNDS;
    private final String dollarReplacement;
    private final String escapeCharReplacement;
    private transient Map escapeCache;
    private transient Map unescapeCache;
    private final String hexPrefix;

    public XmlFriendlyNameCoder() {
        this("_-", "__");
    }

    public XmlFriendlyNameCoder(String string, String string2) {
        this(string, string2, "_.");
    }

    public XmlFriendlyNameCoder(String string, String string2, String string3) {
        this.dollarReplacement = string;
        this.escapeCharReplacement = string2;
        this.hexPrefix = string3;
        this.readResolve();
    }

    public String decodeAttribute(String string) {
        return this.decodeName(string);
    }

    public String decodeNode(String string) {
        return this.decodeName(string);
    }

    public String encodeAttribute(String string) {
        return this.encodeName(string);
    }

    public String encodeNode(String string) {
        return this.encodeName(string);
    }

    private String encodeName(String string) {
        String string2 = (String)this.escapeCache.get(string);
        if (string2 == null) {
            char c2;
            int n2;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && (c2 = string.charAt(n2)) != '$' && c2 != '_' && c2 > '\u001b' && c2 < '\u007f'; ++n2) {
            }
            if (n2 == n3) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(n3 + 8);
            if (n2 > 0) {
                stringBuffer.append(string.substring(0, n2));
            }
            while (n2 < n3) {
                char c3 = string.charAt(n2);
                if (c3 == '$') {
                    stringBuffer.append(this.dollarReplacement);
                } else if (c3 == '_') {
                    stringBuffer.append(this.escapeCharReplacement);
                } else if (n2 == 0 && !XmlFriendlyNameCoder.isXmlNameStartChar(c3) || n2 > 0 && !XmlFriendlyNameCoder.isXmlNameChar(c3)) {
                    stringBuffer.append(this.hexPrefix);
                    if (c3 < '\u0010') {
                        stringBuffer.append("000");
                    } else if (c3 < '\u0100') {
                        stringBuffer.append("00");
                    } else if (c3 < '\u1000') {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(Integer.toHexString(c3));
                } else {
                    stringBuffer.append(c3);
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
            this.escapeCache.put(string, string2);
        }
        return string2;
    }

    private String decodeName(String string) {
        String string2 = (String)this.unescapeCache.get(string);
        if (string2 == null) {
            char c2;
            int n2;
            char c3 = this.dollarReplacement.charAt(0);
            char c4 = this.escapeCharReplacement.charAt(0);
            char c5 = this.hexPrefix.charAt(0);
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && (c2 = string.charAt(n2)) != c3 && c2 != c4 && c2 != c5; ++n2) {
            }
            if (n2 == n3) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(n3 + 8);
            if (n2 > 0) {
                stringBuffer.append(string.substring(0, n2));
            }
            while (n2 < n3) {
                char c6 = string.charAt(n2);
                if (c6 == c3 && string.startsWith(this.dollarReplacement, n2)) {
                    n2 += this.dollarReplacement.length() - 1;
                    stringBuffer.append('$');
                } else if (c6 == c5 && string.startsWith(this.hexPrefix, n2)) {
                    c6 = (char)Integer.parseInt(string.substring(n2 += this.hexPrefix.length(), n2 + 4), 16);
                    n2 += 3;
                    stringBuffer.append(c6);
                } else if (c6 == c4 && string.startsWith(this.escapeCharReplacement, n2)) {
                    n2 += this.escapeCharReplacement.length() - 1;
                    stringBuffer.append('_');
                } else {
                    stringBuffer.append(c6);
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
            this.unescapeCache.put(string, string2);
        }
        return string2;
    }

    public Object clone() {
        try {
            XmlFriendlyNameCoder xmlFriendlyNameCoder = (XmlFriendlyNameCoder)super.clone();
            xmlFriendlyNameCoder.readResolve();
            return xmlFriendlyNameCoder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ObjectAccessException("Cannot clone XmlFriendlyNameCoder", cloneNotSupportedException);
        }
    }

    private Object readResolve() {
        this.escapeCache = this.createCacheMap();
        this.unescapeCache = this.createCacheMap();
        return this;
    }

    protected Map createCacheMap() {
        return new HashMap();
    }

    private static boolean isXmlNameStartChar(int n2) {
        return XmlFriendlyNameCoder.isInNameCharBounds(n2, XML_NAME_START_CHAR_BOUNDS);
    }

    private static boolean isXmlNameChar(int n2) {
        if (XmlFriendlyNameCoder.isXmlNameStartChar(n2)) {
            return true;
        }
        return XmlFriendlyNameCoder.isInNameCharBounds(n2, XML_NAME_CHAR_EXTRA_BOUNDS);
    }

    private static boolean isInNameCharBounds(int n2, IntPair[] intPairArray) {
        for (int i2 = 0; i2 < intPairArray.length; ++i2) {
            IntPair intPair = intPairArray[i2];
            if (n2 < intPair.min || n2 > intPair.max) continue;
            return true;
        }
        return false;
    }

    static {
        class IntPairList
        extends ArrayList {
            IntPairList() {
            }

            void add(int n2, int n3) {
                super.add(new IntPair(n2, n3));
            }

            void add(char c2) {
                super.add(new IntPair(c2, c2));
            }
        }
        IntPairList intPairList = new IntPairList();
        intPairList.add(':');
        intPairList.add(65, 90);
        intPairList.add(97, 122);
        intPairList.add('_');
        intPairList.add(192, 214);
        intPairList.add(216, 246);
        intPairList.add(248, 767);
        intPairList.add(880, 893);
        intPairList.add(895, 8191);
        intPairList.add(8204, 8205);
        intPairList.add(8304, 8591);
        intPairList.add(11264, 12271);
        intPairList.add(12289, 55295);
        intPairList.add(63744, 64975);
        intPairList.add(65008, 65533);
        intPairList.add(65536, 983039);
        XML_NAME_START_CHAR_BOUNDS = intPairList.toArray(new IntPair[intPairList.size()]);
        intPairList.clear();
        intPairList.add('-');
        intPairList.add('.');
        intPairList.add(48, 57);
        intPairList.add('\u00b7');
        intPairList.add(768, 879);
        intPairList.add(8255, 8256);
        XML_NAME_CHAR_EXTRA_BOUNDS = intPairList.toArray(new IntPair[intPairList.size()]);
    }

    private static class IntPair {
        int min;
        int max;

        public IntPair(int n2, int n3) {
            this.min = n2;
            this.max = n3;
        }
    }
}

