/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import zz.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import zz.com.thoughtworks.xstream.io.xml.XomReader;

public class XomDriver
extends AbstractXmlDriver {
    private final Builder builder;

    public XomDriver() {
        this(new XmlFriendlyNameCoder());
    }

    public XomDriver(Builder builder) {
        this(builder, new XmlFriendlyNameCoder());
    }

    public XomDriver(NameCoder nameCoder) {
        super(nameCoder);
        this.builder = null;
    }

    public XomDriver(Builder builder, NameCoder nameCoder) {
        super(nameCoder);
        this.builder = builder;
    }

    public XomDriver(XmlFriendlyReplacer xmlFriendlyReplacer) {
        this((NameCoder)xmlFriendlyReplacer);
    }

    public XomDriver(Builder builder, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(builder, (NameCoder)xmlFriendlyReplacer);
    }

    protected Builder getBuilder() {
        return this.builder;
    }

    protected Builder createBuilder() {
        Builder builder = this.getBuilder();
        return builder != null ? builder : new Builder();
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            Document document = this.createBuilder().build(reader);
            return new XomReader(document, this.getNameCoder());
        }
        catch (ValidityException validityException) {
            throw new StreamException(validityException);
        }
        catch (ParsingException parsingException) {
            throw new StreamException(parsingException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public HierarchicalStreamReader createReader(InputStream inputStream) {
        try {
            Document document = this.createBuilder().build(inputStream);
            return new XomReader(document, this.getNameCoder());
        }
        catch (ValidityException validityException) {
            throw new StreamException(validityException);
        }
        catch (ParsingException parsingException) {
            throw new StreamException(parsingException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public HierarchicalStreamReader createReader(URL uRL) {
        try {
            Document document = this.createBuilder().build(uRL.toExternalForm());
            return new XomReader(document, this.getNameCoder());
        }
        catch (ValidityException validityException) {
            throw new StreamException(validityException);
        }
        catch (ParsingException parsingException) {
            throw new StreamException(parsingException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public HierarchicalStreamReader createReader(File file) {
        try {
            Document document = this.createBuilder().build(file);
            return new XomReader(document, this.getNameCoder());
        }
        catch (ValidityException validityException) {
            throw new StreamException(validityException);
        }
        catch (ParsingException parsingException) {
            throw new StreamException(parsingException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        return new PrettyPrintWriter(writer, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
        return new PrettyPrintWriter((Writer)new OutputStreamWriter(outputStream), this.getNameCoder());
    }
}

