/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Text;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractDocumentReader;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class XomReader
extends AbstractDocumentReader {
    private Element currentElement;

    public XomReader(Element element) {
        super(element);
    }

    public XomReader(Document document) {
        super(document.getRootElement());
    }

    public XomReader(Element element, NameCoder nameCoder) {
        super((Object)element, nameCoder);
    }

    public XomReader(Document document, NameCoder nameCoder) {
        super((Object)document.getRootElement(), nameCoder);
    }

    public XomReader(Element element, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(element, (NameCoder)xmlFriendlyReplacer);
    }

    public XomReader(Document document, XmlFriendlyReplacer xmlFriendlyReplacer) {
        this(document.getRootElement(), (NameCoder)xmlFriendlyReplacer);
    }

    public String getNodeName() {
        return this.decodeNode(this.currentElement.getLocalName());
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.currentElement.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = this.currentElement.getChild(i2);
            if (!(node instanceof Text)) continue;
            Text text = (Text)node;
            stringBuffer.append(text.getValue());
        }
        return stringBuffer.toString();
    }

    public String getAttribute(String string) {
        return this.currentElement.getAttributeValue(this.encodeAttribute(string));
    }

    public String getAttribute(int n2) {
        return this.currentElement.getAttribute(n2).getValue();
    }

    public int getAttributeCount() {
        return this.currentElement.getAttributeCount();
    }

    public String getAttributeName(int n2) {
        return this.decodeAttribute(this.currentElement.getAttribute(n2).getQualifiedName());
    }

    protected int getChildCount() {
        return this.currentElement.getChildElements().size();
    }

    protected Object getParent() {
        return this.currentElement.getParent();
    }

    protected Object getChild(int n2) {
        return this.currentElement.getChildElements().get(n2);
    }

    protected void reassignCurrentElement(Object object) {
        this.currentElement = (Element)object;
    }

    public String peekNextChild() {
        Elements elements = this.currentElement.getChildElements();
        if (null == elements || elements.size() == 0) {
            return null;
        }
        return this.decodeNode(elements.get(0).getLocalName());
    }
}

