/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.io.xml;

import java.io.IOException;
import java.io.Reader;
import zz.com.thoughtworks.xstream.converters.ErrorWriter;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.AbstractPullReader;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import zz.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import zz.org.xmlpull.v1.XmlPullParser;
import zz.org.xmlpull.v1.XmlPullParserException;

public class XppReader
extends AbstractPullReader {
    private final XmlPullParser parser;
    private final Reader reader;

    public XppReader(Reader reader, XmlPullParser xmlPullParser) {
        this(reader, xmlPullParser, new XmlFriendlyNameCoder());
    }

    public XppReader(Reader reader, XmlPullParser xmlPullParser, NameCoder nameCoder) {
        super(nameCoder);
        this.parser = xmlPullParser;
        this.reader = reader;
        try {
            xmlPullParser.setInput(this.reader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new StreamException(xmlPullParserException);
        }
        this.moveDown();
    }

    public XppReader(Reader reader) {
        this(reader, new XmlFriendlyReplacer());
    }

    public XppReader(Reader reader, XmlFriendlyReplacer xmlFriendlyReplacer) {
        super(xmlFriendlyReplacer);
        try {
            this.parser = this.createParser();
            this.reader = reader;
            this.parser.setInput(this.reader);
            this.moveDown();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new StreamException(xmlPullParserException);
        }
    }

    protected XmlPullParser createParser() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            return (XmlPullParser)Class.forName("zz.org.xmlpull.mxp1.MXParser", true, XmlPullParser.class.getClassLoader()).newInstance();
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        throw new StreamException("Cannot create Xpp3 parser instance.", reflectiveOperationException);
    }

    protected int pullNextEvent() {
        try {
            switch (this.parser.next()) {
                case 0: 
                case 2: {
                    return 1;
                }
                case 1: 
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 9: {
                    return 4;
                }
            }
            return 0;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new StreamException(xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    protected String pullElementName() {
        return this.parser.getName();
    }

    protected String pullText() {
        return this.parser.getText();
    }

    public String getAttribute(String string) {
        return this.parser.getAttributeValue(null, this.encodeAttribute(string));
    }

    public String getAttribute(int n2) {
        return this.parser.getAttributeValue(n2);
    }

    public int getAttributeCount() {
        return this.parser.getAttributeCount();
    }

    public String getAttributeName(int n2) {
        return this.decodeAttribute(this.parser.getAttributeName(n2));
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.parser.getLineNumber()));
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }
}

