/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import zz.com.thoughtworks.xstream.InitializationException;
import zz.com.thoughtworks.xstream.annotations.XStreamAlias;
import zz.com.thoughtworks.xstream.annotations.XStreamAliasType;
import zz.com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import zz.com.thoughtworks.xstream.annotations.XStreamConverter;
import zz.com.thoughtworks.xstream.annotations.XStreamConverters;
import zz.com.thoughtworks.xstream.annotations.XStreamImplicit;
import zz.com.thoughtworks.xstream.annotations.XStreamImplicitCollection;
import zz.com.thoughtworks.xstream.annotations.XStreamInclude;
import zz.com.thoughtworks.xstream.annotations.XStreamOmitField;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.ConverterMatcher;
import zz.com.thoughtworks.xstream.converters.ConverterRegistry;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.DependencyInjectionFactory;
import zz.com.thoughtworks.xstream.core.util.TypedNull;
import zz.com.thoughtworks.xstream.mapper.AnnotationConfiguration;
import zz.com.thoughtworks.xstream.mapper.AttributeMapper;
import zz.com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import zz.com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import zz.com.thoughtworks.xstream.mapper.ElementIgnoringMapper;
import zz.com.thoughtworks.xstream.mapper.FieldAliasingMapper;
import zz.com.thoughtworks.xstream.mapper.ImplicitCollectionMapper;
import zz.com.thoughtworks.xstream.mapper.LocalConversionMapper;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMapper
extends MapperWrapper
implements AnnotationConfiguration {
    private boolean locked;
    private transient Object[] arguments;
    private final ConverterRegistry converterRegistry;
    private transient ClassAliasingMapper classAliasingMapper;
    private transient DefaultImplementationsMapper defaultImplementationsMapper;
    private transient ImplicitCollectionMapper implicitCollectionMapper;
    private transient FieldAliasingMapper fieldAliasingMapper;
    private transient ElementIgnoringMapper elementIgnoringMapper;
    private transient AttributeMapper attributeMapper;
    private transient LocalConversionMapper localConversionMapper;
    private final Map<Class<?>, Map<List<Object>, Converter>> converterCache = new HashMap();
    private final Set<Class<?>> annotatedTypes = Collections.synchronizedSet(new HashSet());

    public AnnotationMapper(Mapper mapper, ConverterRegistry converterRegistry, ConverterLookup converterLookup, ClassLoaderReference classLoaderReference, ReflectionProvider reflectionProvider) {
        super(mapper);
        this.converterRegistry = converterRegistry;
        this.annotatedTypes.add(Object.class);
        this.setupMappers();
        this.locked = true;
        ClassLoader classLoader = classLoaderReference.getReference();
        this.arguments = new Object[]{this, classLoaderReference, reflectionProvider, converterLookup, new JVM(), classLoader != null ? classLoader : new TypedNull(ClassLoader.class)};
    }

    public AnnotationMapper(Mapper mapper, ConverterRegistry converterRegistry, ConverterLookup converterLookup, ClassLoader classLoader, ReflectionProvider reflectionProvider, JVM jVM) {
        this(mapper, converterRegistry, converterLookup, new ClassLoaderReference(classLoader), reflectionProvider);
    }

    @Override
    public String realMember(Class clazz, String string) {
        if (!this.locked) {
            this.processAnnotations(clazz);
        }
        return super.realMember(clazz, string);
    }

    @Override
    public String serializedClass(Class clazz) {
        if (!this.locked) {
            this.processAnnotations(clazz);
        }
        return super.serializedClass(clazz);
    }

    @Override
    public Class defaultImplementationOf(Class clazz) {
        if (!this.locked) {
            this.processAnnotations(clazz);
        }
        Class clazz2 = super.defaultImplementationOf(clazz);
        if (!this.locked) {
            this.processAnnotations(clazz2);
        }
        return clazz2;
    }

    @Override
    public Converter getLocalConverter(Class clazz, String string) {
        if (!this.locked) {
            this.processAnnotations(clazz);
        }
        return super.getLocalConverter(clazz, string);
    }

    @Override
    public void autodetectAnnotations(boolean bl2) {
        this.locked = !bl2;
    }

    @Override
    public void processAnnotations(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return;
        }
        this.locked = true;
        UnprocessedTypesSet unprocessedTypesSet = new UnprocessedTypesSet();
        for (Class clazz : classArray) {
            unprocessedTypesSet.add(clazz);
        }
        this.processTypes(unprocessedTypesSet);
    }

    private void processAnnotations(Class clazz) {
        if (clazz == null) {
            return;
        }
        UnprocessedTypesSet unprocessedTypesSet = new UnprocessedTypesSet();
        unprocessedTypesSet.add(clazz);
        this.processTypes(unprocessedTypesSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTypes(Set<Class<?>> set) {
        while (!set.isEmpty()) {
            Iterator<Class<?>> iterator = set.iterator();
            Class<?> clazz = iterator.next();
            iterator.remove();
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                if (this.annotatedTypes.contains(clazz)) {
                    continue;
                }
                try {
                    if (clazz.isPrimitive()) {
                        continue;
                    }
                    this.addParametrizedTypes(clazz, set);
                    this.processConverterAnnotations(clazz);
                    this.processAliasAnnotation(clazz, set);
                    this.processAliasTypeAnnotation(clazz);
                    if (clazz.isInterface()) {
                        continue;
                    }
                    this.processImplicitCollectionAnnotation(clazz);
                    Field[] fieldArray = clazz.getDeclaredFields();
                    for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                        Field field = fieldArray[i2];
                        if (field.isEnumConstant() || (field.getModifiers() & 0x88) > 0) continue;
                        this.addParametrizedTypes(field.getGenericType(), set);
                        if (field.isSynthetic()) continue;
                        this.processFieldAliasAnnotation(field);
                        this.processAsAttributeAnnotation(field);
                        this.processImplicitAnnotation(field);
                        this.processOmitFieldAnnotation(field);
                        this.processLocalConverterAnnotation(field);
                    }
                }
                finally {
                    this.annotatedTypes.add(clazz);
                }
            }
        }
        return;
    }

    private void addParametrizedTypes(Type type, final Set<Class<?>> set) {
        final HashSet<Type> hashSet = new HashSet<Type>();
        LinkedHashSet<Type> linkedHashSet = new LinkedHashSet<Type>(){

            @Override
            public boolean add(Type type) {
                if (type instanceof Class) {
                    return set.add((Class)type);
                }
                return type == null || hashSet.contains(type) ? false : super.add(type);
            }
        };
        while (type != null) {
            Type[] typeArray;
            Object object;
            hashSet.add(type);
            if (type instanceof Class) {
                object = (Class)type;
                set.add((Class<?>)object);
                if (!((Class)object).isPrimitive()) {
                    for (Type type2 : typeArray = ((Class)object).getTypeParameters()) {
                        linkedHashSet.add(type2);
                    }
                    linkedHashSet.add(((Class)object).getGenericSuperclass());
                    for (Type type2 : ((Class)object).getGenericInterfaces()) {
                        linkedHashSet.add(type2);
                    }
                }
            } else if (type instanceof TypeVariable) {
                object = (TypeVariable)type;
                for (Type type2 : typeArray = object.getBounds()) {
                    linkedHashSet.add(type2);
                }
            } else if (type instanceof ParameterizedType) {
                object = (ParameterizedType)type;
                linkedHashSet.add(object.getRawType());
                for (Type type2 : typeArray = object.getActualTypeArguments()) {
                    linkedHashSet.add(type2);
                }
            } else if (type instanceof GenericArrayType) {
                object = (GenericArrayType)type;
                linkedHashSet.add(object.getGenericComponentType());
            }
            if (!linkedHashSet.isEmpty()) {
                object = linkedHashSet.iterator();
                type = (Type)object.next();
                object.remove();
                continue;
            }
            type = null;
        }
    }

    private void processConverterAnnotations(Class<?> clazz) {
        if (this.converterRegistry != null) {
            ArrayList<XStreamConverter> arrayList;
            XStreamConverters xStreamConverters = clazz.getAnnotation(XStreamConverters.class);
            XStreamConverter xStreamConverter = clazz.getAnnotation(XStreamConverter.class);
            ArrayList<XStreamConverter> arrayList2 = arrayList = xStreamConverters != null ? new ArrayList<XStreamConverter>(Arrays.asList(xStreamConverters.value())) : new ArrayList();
            if (xStreamConverter != null) {
                arrayList.add(xStreamConverter);
            }
            for (XStreamConverter xStreamConverter2 : arrayList) {
                Converter converter = this.cacheConverter(xStreamConverter2, xStreamConverter != null ? clazz : null);
                if (converter == null) continue;
                if (xStreamConverter != null || converter.canConvert(clazz)) {
                    this.converterRegistry.registerConverter(converter, xStreamConverter2.priority());
                    continue;
                }
                throw new InitializationException("Converter " + xStreamConverter2.value().getName() + " cannot handle annotated class " + clazz.getName());
            }
        }
    }

    private void processAliasAnnotation(Class<?> clazz, Set<Class<?>> set) {
        XStreamAlias xStreamAlias = clazz.getAnnotation(XStreamAlias.class);
        if (xStreamAlias != null) {
            if (this.classAliasingMapper == null) {
                throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
            }
            this.classAliasingMapper.addClassAlias(xStreamAlias.value(), clazz);
            if (xStreamAlias.impl() != Void.class) {
                this.defaultImplementationsMapper.addDefaultImplementation(xStreamAlias.impl(), clazz);
                if (clazz.isInterface()) {
                    set.add(xStreamAlias.impl());
                }
            }
        }
    }

    private void processAliasTypeAnnotation(Class<?> clazz) {
        XStreamAliasType xStreamAliasType = clazz.getAnnotation(XStreamAliasType.class);
        if (xStreamAliasType != null) {
            if (this.classAliasingMapper == null) {
                throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
            }
            this.classAliasingMapper.addTypeAlias(xStreamAliasType.value(), clazz);
        }
    }

    @Deprecated
    private void processImplicitCollectionAnnotation(Class<?> clazz) {
        XStreamImplicitCollection xStreamImplicitCollection = clazz.getAnnotation(XStreamImplicitCollection.class);
        if (xStreamImplicitCollection != null) {
            Field field;
            if (this.implicitCollectionMapper == null) {
                throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
            }
            String string = xStreamImplicitCollection.value();
            String string2 = xStreamImplicitCollection.item();
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new InitializationException(clazz.getName() + " does not have a field named '" + string + "' as required by " + XStreamImplicitCollection.class.getName());
            }
            Class<?> clazz2 = null;
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                clazz2 = this.getClass(type2);
            }
            if (clazz2 == null) {
                this.implicitCollectionMapper.add(clazz, string, null, Object.class);
            } else if (string2.equals("")) {
                this.implicitCollectionMapper.add(clazz, string, null, clazz2);
            } else {
                this.implicitCollectionMapper.add(clazz, string, string2, clazz2);
            }
        }
    }

    private void processFieldAliasAnnotation(Field field) {
        XStreamAlias xStreamAlias = field.getAnnotation(XStreamAlias.class);
        if (xStreamAlias != null) {
            if (this.fieldAliasingMapper == null) {
                throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
            }
            this.fieldAliasingMapper.addFieldAlias(xStreamAlias.value(), field.getDeclaringClass(), field.getName());
        }
    }

    private void processAsAttributeAnnotation(Field field) {
        XStreamAsAttribute xStreamAsAttribute = field.getAnnotation(XStreamAsAttribute.class);
        if (xStreamAsAttribute != null) {
            if (this.attributeMapper == null) {
                throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
            }
            this.attributeMapper.addAttributeFor(field);
        }
    }

    private void processImplicitAnnotation(Field field) {
        XStreamImplicit xStreamImplicit = field.getAnnotation(XStreamImplicit.class);
        if (xStreamImplicit != null) {
            Type type;
            if (this.implicitCollectionMapper == null) {
                throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
            }
            String string = field.getName();
            String string2 = xStreamImplicit.itemFieldName();
            String string3 = xStreamImplicit.keyFieldName();
            boolean bl2 = Map.class.isAssignableFrom(field.getType());
            Class<?> clazz = null;
            if (!field.getType().isArray() && (type = field.getGenericType()) instanceof ParameterizedType) {
                Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                Type type2 = typeArray[bl2 ? 1 : 0];
                clazz = this.getClass(type2);
            }
            if (bl2) {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), string, string2 != null && !"".equals(string2) ? string2 : null, clazz, string3 != null && !"".equals(string3) ? string3 : null);
            } else if (string2 != null && !"".equals(string2)) {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), string, string2, clazz);
            } else {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), string, clazz);
            }
        }
    }

    private void processOmitFieldAnnotation(Field field) {
        XStreamOmitField xStreamOmitField = field.getAnnotation(XStreamOmitField.class);
        if (xStreamOmitField != null) {
            if (this.elementIgnoringMapper == null) {
                throw new InitializationException("No " + ElementIgnoringMapper.class.getName() + " available");
            }
            this.elementIgnoringMapper.omitField(field.getDeclaringClass(), field.getName());
        }
    }

    private void processLocalConverterAnnotation(Field field) {
        Converter converter;
        XStreamConverter xStreamConverter = field.getAnnotation(XStreamConverter.class);
        if (xStreamConverter != null && (converter = this.cacheConverter(xStreamConverter, field.getType())) != null) {
            if (this.localConversionMapper == null) {
                throw new InitializationException("No " + LocalConversionMapper.class.getName() + " available");
            }
            this.localConversionMapper.registerLocalConverter(field.getDeclaringClass(), field.getName(), converter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Converter cacheConverter(XStreamConverter xStreamConverter, Class clazz) {
        Object object;
        int n2;
        Converter converter = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (clazz != null && xStreamConverter.useImplicitType()) {
            arrayList.add(clazz);
        }
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        arrayList2.add(xStreamConverter.booleans());
        arrayList2.add(xStreamConverter.bytes());
        arrayList2.add(xStreamConverter.chars());
        arrayList2.add(xStreamConverter.doubles());
        arrayList2.add(xStreamConverter.floats());
        arrayList2.add(xStreamConverter.ints());
        arrayList2.add(xStreamConverter.longs());
        arrayList2.add(xStreamConverter.shorts());
        arrayList2.add(xStreamConverter.strings());
        arrayList2.add(xStreamConverter.types());
        for (Object e2 : arrayList2) {
            if (e2 == null) continue;
            n2 = Array.getLength(e2);
            for (int clazz2 = 0; clazz2 < n2; ++clazz2) {
                arrayList.add(Array.get(e2, clazz2));
            }
        }
        for (Class<?> clazz2 : xStreamConverter.nulls()) {
            object = new TypedNull(clazz2);
            arrayList.add(object);
        }
        Class<? extends ConverterMatcher> clazz3 = xStreamConverter.value();
        Map<List<Object>, Converter> map = this.converterCache.get(clazz3);
        if (map != null) {
            converter = map.get(arrayList);
        }
        if (converter == null) {
            void var7_11;
            Converter converter2;
            Object[] objectArray;
            n2 = arrayList.size();
            if (n2 > 0) {
                objectArray = new Object[this.arguments.length + n2];
                System.arraycopy(this.arguments, 0, objectArray, n2, this.arguments.length);
                System.arraycopy(arrayList.toArray(new Object[n2]), 0, objectArray, 0, n2);
            } else {
                objectArray = this.arguments;
            }
            try {
                if (SingleValueConverter.class.isAssignableFrom(clazz3) && !Converter.class.isAssignableFrom(clazz3)) {
                    object = (SingleValueConverter)DependencyInjectionFactory.newInstance(clazz3, objectArray);
                    converter2 = new SingleValueConverterWrapper((SingleValueConverter)object);
                } else {
                    converter2 = (Converter)DependencyInjectionFactory.newInstance(clazz3, objectArray);
                }
            }
            catch (Exception exception) {
                throw new InitializationException("Cannot instantiate converter " + clazz3.getName() + (clazz != null ? " for type " + clazz.getName() : ""), exception);
            }
            if (map == null) {
                HashMap hashMap = new HashMap();
                this.converterCache.put(clazz3, hashMap);
            }
            var7_11.put(arrayList, converter2);
            converter = converter2;
        }
        return converter;
    }

    private Class<?> getClass(Type type) {
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else if (type instanceof Class) {
            clazz = (Class)type;
        }
        return clazz;
    }

    private void setupMappers() {
        this.classAliasingMapper = (ClassAliasingMapper)this.lookupMapperOfType(ClassAliasingMapper.class);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)this.lookupMapperOfType(DefaultImplementationsMapper.class);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)this.lookupMapperOfType(ImplicitCollectionMapper.class);
        this.fieldAliasingMapper = (FieldAliasingMapper)this.lookupMapperOfType(FieldAliasingMapper.class);
        this.elementIgnoringMapper = (ElementIgnoringMapper)this.lookupMapperOfType(ElementIgnoringMapper.class);
        this.attributeMapper = (AttributeMapper)this.lookupMapperOfType(AttributeMapper.class);
        this.localConversionMapper = (LocalConversionMapper)this.lookupMapperOfType(LocalConversionMapper.class);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n2 = this.arguments.length - 2;
        objectOutputStream.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectOutputStream.writeObject(this.arguments[i2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setupMappers();
        int n2 = objectInputStream.readInt();
        this.arguments = new Object[n2 + 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.arguments[i2] = objectInputStream.readObject();
            if (!(this.arguments[i2] instanceof ClassLoaderReference)) continue;
            this.arguments[n2 + 1] = ((ClassLoaderReference)this.arguments[i2]).getReference();
        }
        this.arguments[n2] = new JVM();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnprocessedTypesSet
    extends LinkedHashSet<Class<?>> {
        private UnprocessedTypesSet() {
        }

        @Override
        public boolean add(Class<?> clazz) {
            Class<?>[] classArray;
            XStreamInclude xStreamInclude;
            boolean bl2;
            if (clazz == null) {
                return false;
            }
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string = clazz.getName();
            if (string.startsWith("java.") || string.startsWith("javax.")) {
                return false;
            }
            boolean bl3 = bl2 = AnnotationMapper.this.annotatedTypes.contains(clazz) ? false : super.add(clazz);
            if (bl2 && (xStreamInclude = clazz.getAnnotation(XStreamInclude.class)) != null && (classArray = xStreamInclude.value()) != null) {
                for (Class<?> clazz2 : classArray) {
                    this.add(clazz2);
                }
            }
            return bl2;
        }
    }
}

