/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import zz.com.thoughtworks.xstream.core.util.Primitives;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;

public class ArrayMapper
extends MapperWrapper {
    public ArrayMapper(Mapper mapper) {
        super(mapper);
    }

    public String serializedClass(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while (clazz.isArray()) {
            string = super.serializedClass(clazz);
            if (!clazz.getName().equals(string)) break;
            clazz = clazz.getComponentType();
            stringBuffer.append("-array");
            string = null;
        }
        if (string == null) {
            string = this.boxedTypeName(clazz);
        }
        if (string == null) {
            string = super.serializedClass(clazz);
        }
        if (stringBuffer.length() > 0) {
            return string + stringBuffer;
        }
        return string;
    }

    public Class realClass(String string) {
        int n2 = 0;
        while (string.endsWith("-array")) {
            string = string.substring(0, string.length() - 6);
            ++n2;
        }
        if (n2 > 0) {
            Class<?> clazz = Primitives.primitiveType(string);
            if (clazz == null) {
                clazz = super.realClass(string);
            }
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
                ++n2;
            }
            return super.realClass(this.arrayType(n2, clazz));
        }
        return super.realClass(string);
    }

    private String arrayType(int n2, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('[');
        }
        if (clazz.isPrimitive()) {
            stringBuffer.append(Primitives.representingChar(clazz));
            return stringBuffer.toString();
        }
        stringBuffer.append('L').append(clazz.getName()).append(';');
        return stringBuffer.toString();
    }

    private String boxedTypeName(Class clazz) {
        return Primitives.isBoxed(clazz) ? clazz.getName() : null;
    }
}

