/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;

public class AttributeMapper
extends MapperWrapper {
    private final Map fieldNameToTypeMap = new HashMap();
    private final Set typeSet = new HashSet();
    private ConverterLookup converterLookup;
    private ReflectionProvider reflectionProvider;
    private final Set fieldToUseAsAttribute = new HashSet();

    public AttributeMapper(Mapper mapper) {
        this(mapper, null, null);
    }

    public AttributeMapper(Mapper mapper, ConverterLookup converterLookup, ReflectionProvider reflectionProvider) {
        super(mapper);
        this.converterLookup = converterLookup;
        this.reflectionProvider = reflectionProvider;
    }

    public void setConverterLookup(ConverterLookup converterLookup) {
        this.converterLookup = converterLookup;
    }

    public void addAttributeFor(String string, Class clazz) {
        this.fieldNameToTypeMap.put(string, clazz);
    }

    public void addAttributeFor(Class clazz) {
        this.typeSet.add(clazz);
    }

    private SingleValueConverter getLocalConverterFromItemType(Class clazz) {
        Converter converter = this.converterLookup.lookupConverterForType(clazz);
        if (converter != null && converter instanceof SingleValueConverter) {
            return (SingleValueConverter)((Object)converter);
        }
        return null;
    }

    public SingleValueConverter getConverterFromItemType(String string, Class clazz) {
        if (this.fieldNameToTypeMap.get(string) == clazz) {
            return this.getLocalConverterFromItemType(clazz);
        }
        return null;
    }

    public SingleValueConverter getConverterFromItemType(String string, Class clazz, Class clazz2) {
        SingleValueConverter singleValueConverter;
        if (this.shouldLookForSingleValueConverter(string, clazz, clazz2) && (singleValueConverter = this.getLocalConverterFromItemType(clazz)) != null) {
            return singleValueConverter;
        }
        return super.getConverterFromItemType(string, clazz, clazz2);
    }

    public boolean shouldLookForSingleValueConverter(String string, Class clazz, Class clazz2) {
        if (this.typeSet.contains(clazz)) {
            return true;
        }
        if (this.fieldNameToTypeMap.get(string) == clazz) {
            return true;
        }
        if (string != null && clazz2 != null) {
            Field field = this.reflectionProvider.getField(clazz2, string);
            return this.fieldToUseAsAttribute.contains(field);
        }
        return false;
    }

    public SingleValueConverter getConverterFromItemType(Class clazz) {
        if (this.typeSet.contains(clazz)) {
            return this.getLocalConverterFromItemType(clazz);
        }
        return null;
    }

    public SingleValueConverter getConverterFromAttribute(String string) {
        SingleValueConverter singleValueConverter = null;
        Class clazz = (Class)this.fieldNameToTypeMap.get(string);
        if (clazz != null) {
            singleValueConverter = this.getLocalConverterFromItemType(clazz);
        }
        return singleValueConverter;
    }

    public SingleValueConverter getConverterFromAttribute(Class clazz, String string) {
        Field field = this.reflectionProvider.getField(clazz, string);
        return this.getConverterFromAttribute(clazz, string, field.getType());
    }

    public SingleValueConverter getConverterFromAttribute(Class clazz, String string, Class clazz2) {
        SingleValueConverter singleValueConverter;
        if (this.shouldLookForSingleValueConverter(string, clazz2, clazz) && (singleValueConverter = this.getLocalConverterFromItemType(clazz2)) != null) {
            return singleValueConverter;
        }
        return super.getConverterFromAttribute(clazz, string, clazz2);
    }

    public void addAttributeFor(Field field) {
        this.fieldToUseAsAttribute.add(field);
    }

    public void addAttributeFor(Class clazz, String string) {
        this.fieldToUseAsAttribute.add(this.reflectionProvider.getField(clazz, string));
    }
}

