/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.XStreamException;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.mapper.CannotResolveClassException;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;
import zz.com.thoughtworks.xstream.security.ForbiddenClassException;

public class CachingMapper
extends MapperWrapper
implements Caching {
    private transient Map realClassCache;

    public CachingMapper(Mapper mapper) {
        super(mapper);
        this.readResolve();
    }

    public Class realClass(String string) {
        Object v2 = this.realClassCache.get(string);
        if (v2 != null) {
            if (v2 instanceof Class) {
                return (Class)v2;
            }
            throw (XStreamException)v2;
        }
        try {
            Class clazz = super.realClass(string);
            this.realClassCache.put(string, clazz);
            return clazz;
        }
        catch (ForbiddenClassException forbiddenClassException) {
            this.realClassCache.put(string, forbiddenClassException);
            throw forbiddenClassException;
        }
        catch (CannotResolveClassException cannotResolveClassException) {
            this.realClassCache.put(string, cannotResolveClassException);
            throw cannotResolveClassException;
        }
    }

    public void flushCache() {
        this.realClassCache.clear();
    }

    private Object readResolve() {
        this.realClassCache = Collections.synchronizedMap(new HashMap(128));
        return this;
    }
}

