/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.core.util.Primitives;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;

public class ClassAliasingMapper
extends MapperWrapper {
    private final Map typeToName = new HashMap();
    private final Map classToName = new HashMap();
    private transient Map nameToType = new HashMap();

    public ClassAliasingMapper(Mapper mapper) {
        super(mapper);
    }

    public void addClassAlias(String string, Class clazz) {
        this.nameToType.put(string, clazz.getName());
        this.classToName.put(clazz.getName(), string);
    }

    public void addClassAttributeAlias(String string, Class clazz) {
        this.addClassAlias(string, clazz);
    }

    public void addTypeAlias(String string, Class clazz) {
        this.nameToType.put(string, clazz.getName());
        this.typeToName.put(clazz, string);
    }

    public String serializedClass(Class clazz) {
        String string = (String)this.classToName.get(clazz.getName());
        if (string != null) {
            return string;
        }
        for (Class clazz2 : this.typeToName.keySet()) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return (String)this.typeToName.get(clazz2);
        }
        return super.serializedClass(clazz);
    }

    public Class realClass(String string) {
        String string2 = (String)this.nameToType.get(string);
        if (string2 != null) {
            Class clazz = Primitives.primitiveType(string2);
            if (clazz != null) {
                return clazz;
            }
            string = string2;
        }
        return super.realClass(string);
    }

    public boolean itemTypeAsAttribute(Class clazz) {
        return this.classToName.containsKey(clazz.getName());
    }

    public boolean aliasIsAttribute(String string) {
        return this.nameToType.containsKey(string);
    }

    private Object readResolve() {
        this.nameToType = new HashMap();
        for (Object object : this.classToName.keySet()) {
            this.nameToType.put(this.classToName.get(object), object);
        }
        for (Object object : this.typeToName.keySet()) {
            this.nameToType.put(this.typeToName.get(object), ((Class)object).getName());
        }
        return this;
    }
}

