/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.InitializationException;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;

public class DefaultImplementationsMapper
extends MapperWrapper {
    private final Map typeToImpl = new HashMap();
    private transient Map implToType = new HashMap();

    public DefaultImplementationsMapper(Mapper mapper) {
        super(mapper);
        this.addDefaults();
    }

    protected void addDefaults() {
        this.addDefaultImplementation(null, Mapper.Null.class);
        this.addDefaultImplementation(Boolean.class, Boolean.TYPE);
        this.addDefaultImplementation(Character.class, Character.TYPE);
        this.addDefaultImplementation(Integer.class, Integer.TYPE);
        this.addDefaultImplementation(Float.class, Float.TYPE);
        this.addDefaultImplementation(Double.class, Double.TYPE);
        this.addDefaultImplementation(Short.class, Short.TYPE);
        this.addDefaultImplementation(Byte.class, Byte.TYPE);
        this.addDefaultImplementation(Long.class, Long.TYPE);
    }

    public void addDefaultImplementation(Class clazz, Class clazz2) {
        if (clazz != null && clazz.isInterface()) {
            throw new InitializationException("Default implementation is not a concrete class: " + clazz.getName());
        }
        this.typeToImpl.put(clazz2, clazz);
        this.implToType.put(clazz, clazz2);
    }

    public String serializedClass(Class clazz) {
        Class clazz2 = (Class)this.implToType.get(clazz);
        return clazz2 == null ? super.serializedClass(clazz) : super.serializedClass(clazz2);
    }

    public Class defaultImplementationOf(Class clazz) {
        if (this.typeToImpl.containsKey(clazz)) {
            return (Class)this.typeToImpl.get(clazz);
        }
        return super.defaultImplementationOf(clazz);
    }

    private Object readResolve() {
        this.implToType = new HashMap();
        for (Object k2 : this.typeToImpl.keySet()) {
            this.implToType.put(this.typeToImpl.get(k2), k2);
        }
        return this;
    }
}

