/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import zz.com.thoughtworks.xstream.core.util.FastField;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;

public class ElementIgnoringMapper
extends MapperWrapper {
    protected final Set fieldsToOmit = new HashSet();
    protected final Set unknownElementsToIgnore = new LinkedHashSet();

    public ElementIgnoringMapper(Mapper mapper) {
        super(mapper);
    }

    public void addElementsToIgnore(Pattern pattern) {
        this.unknownElementsToIgnore.add(pattern);
    }

    public void omitField(Class clazz, String string) {
        this.fieldsToOmit.add(this.key(clazz, string));
    }

    public boolean shouldSerializeMember(Class clazz, String string) {
        if (this.fieldsToOmit.contains(this.key(clazz, string))) {
            return false;
        }
        if (clazz == Object.class && this.isIgnoredElement(string)) {
            return false;
        }
        return super.shouldSerializeMember(clazz, string);
    }

    public boolean isIgnoredElement(String string) {
        if (!this.unknownElementsToIgnore.isEmpty()) {
            for (Pattern pattern : this.unknownElementsToIgnore) {
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
        }
        return super.isIgnoredElement(string);
    }

    private Object key(Class clazz, String string) {
        return new FastField(clazz, string);
    }
}

