/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.enums.EnumSingleValueConverter;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.mapper.AttributeMapper;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;

public class EnumMapper
extends MapperWrapper
implements Caching {
    private transient AttributeMapper attributeMapper;
    private transient Map<Class, SingleValueConverter> enumConverterMap;

    @Deprecated
    public EnumMapper(Mapper mapper, ConverterLookup converterLookup) {
        super(mapper);
        this.readResolve();
    }

    public EnumMapper(Mapper mapper) {
        super(mapper);
        this.readResolve();
    }

    public String serializedClass(Class clazz) {
        if (clazz == null) {
            return super.serializedClass(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz) && clazz.getSuperclass() != Enum.class) {
            return super.serializedClass(clazz.getSuperclass());
        }
        if (EnumSet.class.isAssignableFrom(clazz)) {
            return super.serializedClass(EnumSet.class);
        }
        return super.serializedClass(clazz);
    }

    public boolean isImmutableValueType(Class clazz) {
        return Enum.class.isAssignableFrom(clazz) || super.isImmutableValueType(clazz);
    }

    public boolean isReferenceable(Class clazz) {
        if (clazz != null && Enum.class.isAssignableFrom(clazz)) {
            return false;
        }
        return super.isReferenceable(clazz);
    }

    public SingleValueConverter getConverterFromItemType(String string, Class clazz, Class clazz2) {
        SingleValueConverter singleValueConverter = this.getLocalConverter(string, clazz, clazz2);
        return singleValueConverter == null ? super.getConverterFromItemType(string, clazz, clazz2) : singleValueConverter;
    }

    public SingleValueConverter getConverterFromAttribute(Class clazz, String string, Class clazz2) {
        SingleValueConverter singleValueConverter = this.getLocalConverter(string, clazz2, clazz);
        return singleValueConverter == null ? super.getConverterFromAttribute(clazz, string, clazz2) : singleValueConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleValueConverter getLocalConverter(String string, Class clazz, Class clazz2) {
        if (this.attributeMapper != null && Enum.class.isAssignableFrom(clazz) && this.attributeMapper.shouldLookForSingleValueConverter(string, clazz, clazz2)) {
            Map<Class, SingleValueConverter> map = this.enumConverterMap;
            synchronized (map) {
                SingleValueConverter singleValueConverter = this.enumConverterMap.get(clazz);
                if (singleValueConverter == null) {
                    singleValueConverter = super.getConverterFromItemType(string, clazz, clazz2);
                    if (singleValueConverter == null) {
                        Class clazz3 = clazz;
                        singleValueConverter = new EnumSingleValueConverter(clazz3);
                    }
                    this.enumConverterMap.put(clazz, singleValueConverter);
                }
                return singleValueConverter;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        if (this.enumConverterMap.size() > 0) {
            Map<Class, SingleValueConverter> map = this.enumConverterMap;
            synchronized (map) {
                this.enumConverterMap.clear();
            }
        }
    }

    private Object readResolve() {
        this.enumConverterMap = new HashMap<Class, SingleValueConverter>();
        this.attributeMapper = (AttributeMapper)this.lookupMapperOfType(AttributeMapper.class);
        return this;
    }
}

