/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.mapper;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.core.Caching;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;

public class OuterClassMapper
extends MapperWrapper
implements Caching {
    private static final String[] EMPTY_NAMES = new String[0];
    private final String alias;
    private final Map innerFields;

    public OuterClassMapper(Mapper mapper) {
        this(mapper, "outer-class");
    }

    public OuterClassMapper(Mapper mapper, String string) {
        super(mapper);
        this.alias = string;
        this.innerFields = Collections.synchronizedMap(new HashMap());
        this.innerFields.put(Object.class.getName(), EMPTY_NAMES);
    }

    public String serializedMember(Class clazz, String string) {
        if (string.startsWith("this$")) {
            String[] stringArray = this.getInnerFieldNames(clazz);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2].equals(string)) continue;
                return i2 == 0 ? this.alias : this.alias + '-' + i2;
            }
        }
        return super.serializedMember(clazz, string);
    }

    public String realMember(Class clazz, String string) {
        if (string.startsWith(this.alias)) {
            String[] stringArray;
            int n2 = -1;
            int n3 = this.alias.length();
            if (n3 == string.length()) {
                n2 = 0;
            } else if (string.length() > n3 + 1 && string.charAt(n3) == '-') {
                n2 = Integer.valueOf(string.substring(n3 + 1));
            }
            if (n2 >= 0 && n2 < (stringArray = this.getInnerFieldNames(clazz)).length) {
                return stringArray[n2];
            }
        }
        return super.realMember(clazz, string);
    }

    private String[] getInnerFieldNames(Class clazz) {
        String[] stringArray = (String[])this.innerFields.get(clazz.getName());
        if (stringArray == null) {
            stringArray = this.getInnerFieldNames(clazz.getSuperclass());
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                Field field = fieldArray[i2];
                if (!field.getName().startsWith("this$")) continue;
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray = stringArray2;
                stringArray[stringArray.length - 1] = field.getName();
            }
            this.innerFields.put(clazz.getName(), stringArray);
        }
        return stringArray;
    }

    public void flushCache() {
        this.innerFields.keySet().retainAll(Collections.singletonList(Object.class.getName()));
    }
}

